/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import org.apache.commons.lang3.tuple.Pair;
import quarris.enchantability.mod.capability.player.CapabilityHandler;
import quarris.enchantability.mod.capability.player.enchant.IPlayerEnchHandler;

public class CommandRemoveEnchant
extends CommandBase {
    public String func_71517_b() {
        return "remove";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/ench remove <Player> <Enchantment>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 2) {
            throw new CommandException("Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = server.func_184103_al().func_152612_a(args[0]);
        Enchantment enchantment = Enchantment.func_180305_b((String)args[1]);
        if (player == null) {
            throw new CommandException("Player '" + args[0] + "' does not exist.", new Object[0]);
        }
        if (enchantment == null) {
            throw new CommandException("Enchantment '" + args[1] + "' does not exist.", new Object[0]);
        }
        IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
        if (cap != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Successfully removed " + I18n.func_74838_a((String)enchantment.func_77320_a()) + " from " + player.func_70005_c_()));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandRemoveEnchant.func_71530_a((String[])args, (String[])server.func_184103_al().func_72369_d());
        }
        if (args.length == 2) {
            IPlayerEnchHandler cap;
            ArrayList<String> enchantments = new ArrayList<String>();
            EntityPlayerMP player = server.func_184103_al().func_152612_a(args[0]);
            if (player != null && (cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null)) != null) {
                for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                    enchantments.add(((Enchantment)pair.getLeft()).getRegistryName().toString());
                }
                return CommandRemoveEnchant.func_175762_a((String[])args, enchantments);
            }
        }
        return Collections.emptyList();
    }
}

