/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.enchant.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import quarris.enchantability.api.EnchantabilityAPI;
import quarris.enchantability.api.enchant.AbstractEnchantEffect;
import quarris.enchantability.api.enchant.mending.MendingAction;
import quarris.enchantability.api.enchant.mending.MendingResult;
import quarris.enchantability.mod.Enchantability;
import quarris.enchantability.mod.config.ConfigEnchants;
import quarris.enchantability.mod.utils.EnchantmentUtils;

public class EnchantEffectMending
extends AbstractEnchantEffect {
    public static void registerFoodActions() {
        if (ConfigEnchants.mendingEffects.pumpkinPieEffect) {
            EnchantabilityAPI.getInstance().addToMendingList((ItemFood)Items.field_151158_bO, new MendingAction(mendingResult -> {
                EntityPlayer player = mendingResult.player;
                List list = player.field_70170_p.func_175644_a(EntityEnderman.class, enderman -> enderman.func_70638_az() == player);
                for (EntityEnderman enderman2 : list) {
                    for (EntityAITasks.EntityAITaskEntry ai : enderman2.field_70715_bh.field_75782_a) {
                        if (ai.field_75731_b != 1) continue;
                        ReflectionHelper.setPrivateValue(EntityAINearestAttackableTarget.class, (Object)((EntityAINearestAttackableTarget)ai.field_75733_a), null, (int)4);
                        ai.field_75733_a.func_75251_c();
                    }
                }
            }, 25));
        }
        if (ConfigEnchants.mendingEffects.rabbitStewEffect) {
            EnchantabilityAPI.getInstance().addToMendingList((ItemFood)Items.field_179560_bq, new MendingAction(mendingResult -> mendingResult.player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 1200, mendingResult.tier + 2)), 20));
        }
        if (ConfigEnchants.mendingEffects.cookieEffect) {
            EnchantabilityAPI.getInstance().addToMendingList((ItemFood)Items.field_151106_aX, new MendingAction(mendingResult -> {
                mendingResult.player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 600, 1));
                mendingResult.player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 300, 0));
            }, 10));
        }
        if (ConfigEnchants.mendingEffects.mushroomStewEffect) {
            EnchantabilityAPI.getInstance().addToMendingList((ItemFood)Items.field_151009_A, new MendingAction(mendingResult -> mendingResult.player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 1200, 0)), 10));
        }
        if (ConfigEnchants.mendingEffects.spiderEyeEffect) {
            EnchantabilityAPI.getInstance().addToMendingList((ItemFood)Items.field_151070_bp, new MendingAction(mendingResult -> mendingResult.player.func_70690_d(new PotionEffect(Enchantability.SPIDER_CLIMB, 900, 0)), 30));
        }
    }

    @Override
    public ItemStack onItemUseFinish(EntityPlayer player, ItemStack item, ItemStack result, int tier) {
        if (item.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)item.func_77973_b();
            for (MendingAction action : EnchantabilityAPI.MENDING_EFFECTS.get((Object)food)) {
                if (action.cost > EnchantmentUtils.getPlayerXP(player)) continue;
                action.result.accept(new MendingResult(item, player, tier));
                EnchantmentUtils.addPlayerXP(player, -action.cost);
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public Enchantment getEnchantment() {
        return Enchantments.field_185296_A;
    }

    @Override
    @Nullable
    public String getDescription() {
        return TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"tooltip.effect.mending", (Object[])new Object[0]);
    }
}

