/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.event;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import quarris.enchantability.api.enchant.EnchantEffectRegistry;
import quarris.enchantability.api.enchant.IEnchantEffect;
import quarris.enchantability.mod.capability.player.CapabilityHandler;
import quarris.enchantability.mod.capability.player.enchant.IPlayerEnchHandler;

public class EnchantEffectEventHandler {
    @SubscribeEvent
    public void handleEffectBreakSpeed(PlayerEvent.BreakSpeed e) {
        EntityPlayer player = e.getEntityPlayer();
        IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
        block0: for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
            List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
            for (IEnchantEffect effect : effects) {
                float out = effect.breakSpeed(player, e.getState(), e.getPos(), e.getOriginalSpeed(), (Integer)pair.getRight());
                if (out == e.getOriginalSpeed()) continue;
                if (out < 0.0f) {
                    e.setCanceled(true);
                    continue;
                }
                e.setNewSpeed(out);
                continue block0;
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnItemUseFinish(LivingEntityUseItemEvent.Finish e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    e.setResultStack(effect.onItemUseFinish(player, e.getItem(), e.getResultStack(), (Integer)pair.getRight()));
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnExplosionStart(ExplosionEvent.Start e) {
        for (EntityPlayer player : e.getExplosion().func_77277_b().keySet()) {
            IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            boolean shouldCancel = false;
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    if (!effect.onExplosionStart(player, e.getExplosion(), (Integer)pair.getRight())) continue;
                    shouldCancel = true;
                }
            }
            if (!shouldCancel) continue;
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleEffectOnProjectileImpact(ProjectileImpactEvent e) {
        if (e.getRayTraceResult().field_72308_g instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getRayTraceResult().field_72308_g;
            IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            boolean shouldCancel = false;
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    if (!effect.onProjectileImpact(player, e.getEntity(), (Integer)pair.getRight())) continue;
                    shouldCancel = true;
                }
            }
            if (shouldCancel) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnExplosionDetonate(ExplosionEvent.Detonate e) {
        for (Entity entity : e.getAffectedEntities()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    effect.onExplosionDetonate(player, e.getExplosion(), e.getAffectedEntities(), (Integer)pair.getRight());
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnPlayerDamageTaken(LivingDamageEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    float amount = effect.onPlayerDamageTaken(player, e.getSource(), e.getAmount(), (Integer)pair.getRight());
                    if (amount <= 0.0f) {
                        e.setCanceled(true);
                        return;
                    }
                    e.setAmount(amount);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnPlayerHurt(LivingHurtEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    float amount = effect.onPlayerHurt(player, e.getSource(), e.getAmount(), (Integer)pair.getRight());
                    if (amount <= 0.0f) {
                        e.setCanceled(true);
                        return;
                    }
                    e.setAmount(amount);
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnPlayerAttack(AttackEntityEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
        for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
            List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
            for (IEnchantEffect effect : effects) {
                e.setCanceled(effect.onPlayerAttack(player, e.getTarget(), (Integer)pair.getRight()));
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnPlayerDeathPre(LivingDeathEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    e.setCanceled(effect.onPlayerDeathPre(player, (Integer)pair.getRight()));
                }
            }
        }
    }

    public static void handleEffectOnPlayerDeath(PlayerEvent.Clone e) {
        EntityPlayer player;
        IPlayerEnchHandler cap;
        if (e.isWasDeath() && (cap = (IPlayerEnchHandler)(player = e.getEntityPlayer()).getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null)) != null) {
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    effect.onPlayerDeath(e.getOriginal(), player, (Integer)pair.getRight());
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnPlayerDeathPost(PlayerEvent.PlayerRespawnEvent e) {
        EntityPlayer player;
        IPlayerEnchHandler cap;
        ArrayList<Object> toDelete = new ArrayList<Object>();
        if (!e.isEndConquered() && (cap = (IPlayerEnchHandler)(player = e.player).getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null)) != null) {
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    if (!effect.onPlayerDeathPost(player, (Integer)pair.getRight())) continue;
                    toDelete.add(pair.getLeft());
                }
            }
            for (Enchantment enchantment : toDelete) {
                cap.removeEnchant(enchantment);
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnItemCrafted(PlayerEvent.ItemCraftedEvent e) {
        EntityPlayer player = e.player;
        IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
        for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
            List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
            for (IEnchantEffect effect : effects) {
                effect.onItemCrafted(player, e.crafting, (Integer)pair.getRight());
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnItemSmelted(PlayerEvent.ItemSmeltedEvent e) {
        EntityPlayer player = e.player;
        IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
        for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
            List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
            for (IEnchantEffect effect : effects) {
                effect.onItemSmelted(player, e.smelting, (Integer)pair.getRight());
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnExperienceDrop(LivingExperienceDropEvent e) {
        EntityPlayer player = e.getAttackingPlayer();
        if (player != null) {
            EntityLivingBase dropper = e.getEntityLiving();
            int originalXP = e.getOriginalExperience();
            IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    int droppedXP = e.getDroppedExperience();
                    e.setDroppedExperience(effect.onExperienceDrop(player, dropper, originalXP, droppedXP, (Integer)pair.getRight()));
                }
            }
        }
    }

    @SubscribeEvent
    public void handleEffectOnLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntityLiving();
            IPlayerEnchHandler cap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    effect.onLivingUpdate(player, (Integer)pair.getRight());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleEffectOnPlayerRender(RenderPlayerEvent.Pre e) {
        IPlayerEnchHandler cap = (IPlayerEnchHandler)e.getEntityPlayer().getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
        boolean shouldCancel = false;
        for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
            List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
            for (IEnchantEffect effect : effects) {
                if (!effect.onRenderPlayer(e.getEntityPlayer(), e.getRenderer(), (Integer)pair.getRight())) continue;
                shouldCancel = true;
            }
        }
        if (shouldCancel) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleEffectOnTick(TickEvent.PlayerTickEvent e) {
        if (e.side.isServer() && e.phase == TickEvent.Phase.END) {
            IPlayerEnchHandler cap = (IPlayerEnchHandler)e.player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            for (Pair<Enchantment, Integer> pair : cap.getEnchants()) {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment((Enchantment)pair.getLeft());
                for (IEnchantEffect effect : effects) {
                    effect.onTick(e.player, (Integer)pair.getRight());
                }
            }
        }
    }
}

