/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.event;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.player.inventory.ContainerLocalMenu;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import quarris.enchantability.api.enchant.EnchantEffectRegistry;
import quarris.enchantability.api.enchant.IEnchantEffect;
import quarris.enchantability.mod.Enchantability;
import quarris.enchantability.mod.capability.player.CapabilityHandler;
import quarris.enchantability.mod.capability.player.container.EnchantItemHandler;
import quarris.enchantability.mod.capability.player.container.EnchantItemProvider;
import quarris.enchantability.mod.capability.player.container.IEnchantItemHandler;
import quarris.enchantability.mod.capability.player.enchant.IPlayerEnchHandler;
import quarris.enchantability.mod.capability.player.enchant.PlayerEnchHandler;
import quarris.enchantability.mod.capability.player.enchant.PlayerEnchProvider;
import quarris.enchantability.mod.container.gui.GuiEnch;
import quarris.enchantability.mod.container.gui.GuiEnchButton;
import quarris.enchantability.mod.event.EnchantEffectEventHandler;
import quarris.enchantability.mod.network.PacketHandler;
import quarris.enchantability.mod.network.PacketSendCapsToClients;

public class ModEvents {
    @SubscribeEvent
    public void playerJoinWorld(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            if (!e.getWorld().field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new PacketSendCapsToClients(player));
            }
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent e) {
        EntityLivingBase entity = e.getEntityLiving();
        if (entity.func_70660_b(Enchantability.SPIDER_CLIMB) != null) {
            if (entity.field_70123_F) {
                entity.field_70143_R = 0.0f;
            } else {
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos statePos = new BlockPos(entity.func_180425_c().func_177958_n() + facing.func_82601_c(), entity.func_180425_c().func_177956_o(), entity.func_180425_c().func_177952_p() + facing.func_82599_e());
                    IBlockState state = entity.field_70170_p.func_180495_p(statePos);
                    if (state.func_185904_a() == Material.field_151579_a) continue;
                    entity.field_70143_R = 0.0f;
                }
            }
        }
    }

    @SubscribeEvent
    public void attachCapabilityEntity(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getObject();
            e.addCapability(new ResourceLocation("enchantability", "enchant"), (ICapabilityProvider)new PlayerEnchProvider(new PlayerEnchHandler(player)));
            e.addCapability(new ResourceLocation("enchantability", "enchantInv"), (ICapabilityProvider)new EnchantItemProvider(new EnchantItemHandler(player)));
        }
    }

    @SubscribeEvent
    public void cloneCapabilities(PlayerEvent.Clone e) {
        if (e.isWasDeath()) {
            try {
                IPlayerEnchHandler coEnch = (IPlayerEnchHandler)e.getOriginal().getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
                NBTTagList nbtEnch = coEnch.serializeNBT();
                IPlayerEnchHandler cnEnch = (IPlayerEnchHandler)e.getEntityPlayer().getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
                cnEnch.deserializeNBT(nbtEnch);
                IEnchantItemHandler coItem = (IEnchantItemHandler)e.getOriginal().getCapability(CapabilityHandler.ENCHANT_INVENTORY_CAPABILITY, null);
                NBTTagCompound nbtItem = coItem.serializeNBT();
                IEnchantItemHandler cnItem = (IEnchantItemHandler)e.getEntityPlayer().getCapability(CapabilityHandler.ENCHANT_INVENTORY_CAPABILITY, null);
                cnItem.deserializeNBT(nbtItem);
            }
            catch (Exception exp) {
                Enchantability.logger.warn("Failed to clone player " + e.getOriginal().func_70005_c_(), (Throwable)exp);
            }
        }
        EnchantEffectEventHandler.handleEffectOnPlayerDeath(e);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.side.isServer() && e.phase == TickEvent.Phase.END) {
            EntityPlayer player = e.player;
            IPlayerEnchHandler enchCap = (IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null);
            IEnchantItemHandler invCap = (IEnchantItemHandler)player.getCapability(CapabilityHandler.ENCHANT_INVENTORY_CAPABILITY, null);
            if (enchCap != null && invCap != null && enchCap.isDirty()) {
                invCap.updateEnchants();
                enchCap.markClean();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void initGuiEnderChest(GuiScreenEvent.InitGuiEvent e) {
        if (e.getGui() instanceof GuiChest) {
            ContainerChest containerChest;
            GuiChest guiChest = (GuiChest)e.getGui();
            if (guiChest.field_147002_h instanceof ContainerChest && (containerChest = (ContainerChest)guiChest.field_147002_h).func_85151_d() instanceof InventoryBasic && !(containerChest.func_85151_d() instanceof ContainerLocalMenu)) {
                e.getButtonList().add(new GuiEnchButton(837259834, (GuiContainer)guiChest, guiChest.getGuiLeft() - 18, guiChest.getGuiTop() + 143, 0));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addTooltipToEnchantedBooks(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        if (e.getEntity() == null || Minecraft.func_71410_x().field_71462_r instanceof GuiEnch || e.getEntityPlayer().func_184812_l_() && Keyboard.isKeyDown((int)42)) {
            NBTTagList enchants = stack.serializeNBT().func_74775_l("tag").func_150295_c("StoredEnchantments", 10);
            String baseTooltip = TextFormatting.YELLOW + TextFormatting.BOLD + I18n.func_135052_a((String)"tooltip.info_name", (Object[])new Object[0]) + " ";
            LinkedList<String> effectTooltips = new LinkedList<String>();
            if (enchants.func_74745_c() != 1) {
                baseTooltip = baseTooltip + TextFormatting.RESET + TextFormatting.RED + I18n.func_135052_a((String)"tooltip.bad_count", (Object[])new Object[0]);
            } else {
                List<IEnchantEffect> effects = EnchantEffectRegistry.getEffectsFromEnchantment(Enchantment.func_185262_c((int)enchants.func_150305_b(0).func_74765_d("id")));
                if (effects.isEmpty()) {
                    baseTooltip = baseTooltip + TextFormatting.RESET + TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.no_effect", (Object[])new Object[0]);
                } else {
                    for (IEnchantEffect effect : effects) {
                        if (effect.getDescription() == null) continue;
                        effectTooltips.add(effect.getDescription());
                    }
                    baseTooltip = effectTooltips.isEmpty() ? baseTooltip + TextFormatting.RESET + TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.no_info", (Object[])new Object[0]) : baseTooltip + TextFormatting.RESET + TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.info", (Object[])new Object[0]);
                }
            }
            e.getToolTip().add(baseTooltip);
            if (!effectTooltips.isEmpty()) {
                for (String s : effectTooltips) {
                    e.getToolTip().add(s);
                }
            }
        }
    }

    @SubscribeEvent
    public void configChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals("enchantability")) {
            ConfigManager.sync((String)e.getModID(), (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onHitBlock(PlayerInteractEvent.LeftClickBlock e) {
        IBlockState state = e.getEntityPlayer().field_70170_p.func_180495_p(e.getPos());
        if (state.func_177230_c() == Enchantability.AIR_ICE) {
            e.setCanceled(true);
        }
    }
}

