/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quarris.enchantability.mod.capability.player.CapabilityHandler;
import quarris.enchantability.mod.capability.player.enchant.IPlayerEnchHandler;

public class PacketSendCapsToClients
implements IMessage,
IMessageHandler<PacketSendCapsToClients, IMessage> {
    private NBTTagList dataList;
    private UUID playerUUID;

    public PacketSendCapsToClients() {
        this.dataList = new NBTTagList();
    }

    public PacketSendCapsToClients(EntityPlayer player) {
        this.dataList = ((IPlayerEnchHandler)player.getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null)).serializeNBT();
        this.playerUUID = player.func_110124_au();
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        this.playerUUID = new UUID(buffer.readLong(), buffer.readLong());
        while (buffer.readableBytes() > 0) {
            try {
                this.dataList.func_74742_a((NBTBase)buffer.func_150793_b());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.writeLong(this.playerUUID.getMostSignificantBits());
        buffer.writeLong(this.playerUUID.getLeastSignificantBits());
        for (NBTBase base : this.dataList) {
            NBTTagCompound tag = (NBTTagCompound)base;
            buffer.func_150786_a(tag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketSendCapsToClients message, MessageContext ctx) {
        Minecraft mainThread = Minecraft.func_71410_x();
        mainThread.func_152344_a(() -> {
            EntityPlayerSP player;
            IPlayerEnchHandler cap;
            if (Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(message.playerUUID) && (cap = (IPlayerEnchHandler)(player = Minecraft.func_71410_x().field_71439_g).getCapability(CapabilityHandler.PLAYER_ENCHANT_CAPABILITY, null)) != null) {
                cap.deserializeNBT(message.dataList);
            }
        });
        return null;
    }
}

