/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.eventbus.api.Event;
import quarris.enchantability.api.IEffectComponent;
import quarris.enchantability.api.IEffectSupplier;
import quarris.enchantability.api.capabilities.IPlayerEnchant;
import quarris.enchantability.api.enchants.IEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.GluttonyEnchantEffect;

public class EnchantabilityApi {
    private static IInternals instance = null;
    public static final List<ItemStack> DEXTERITY_ITEMSTACKS = new ArrayList<ItemStack>();
    public static final List<Tag<Item>> DEXTERITY_TAGS = new ArrayList<Tag<Item>>();
    public static final Multimap<Food, BiConsumer<GluttonyEnchantEffect, ItemStack>> GLUTTONY_FOODS = HashMultimap.create();
    @CapabilityInject(value=IPlayerEnchant.class)
    public static Capability<IPlayerEnchant> playerEnchant;

    public static IInternals getInstance() {
        if (instance == null) {
            throw new NullPointerException("EnchantabilityAPI: The instance was accessed before it was initialised.");
        }
        return instance;
    }

    public static void setInstance(IInternals inst) {
        if (instance == null) {
            instance = inst;
        }
    }

    public static interface IInternals {
        public void registerEnchantEffect(ResourceLocation var1, Enchantment var2, IEffectSupplier var3);

        public <F extends IEnchantEffect, T extends Event> void registerEffectComponent(ResourceLocation var1, Class<T> var2, IEffectComponent<F, T> var3, Function<T, Collection<PlayerEntity>> var4);

        public List<IEffectSupplier> getEnchantEffects(Enchantment var1);

        public IEffectSupplier getEnchantEffect(ResourceLocation var1);

        public void addToMendingList(Food var1, BiConsumer<GluttonyEnchantEffect, ItemStack> var2);

        public void addToDexterityList(Object ... var1);
    }
}

