/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.api.capabilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.api.IEffectSupplier;
import quarris.enchantability.api.enchants.IEnchantEffect;

public interface IPlayerEnchant
extends IItemHandlerModifiable,
ICapabilitySerializable<CompoundNBT> {
    public List<IEnchantEffect> getEnchants();

    public PlayerEntity getPlayer();

    public boolean hasEnchant(ResourceLocation var1);

    public IEnchantEffect getEnchant(ResourceLocation var1);

    default public Map<Enchantment, Integer> getStoredEnchantments() {
        HashMap<Enchantment, Integer> storedEnchantments = new HashMap<Enchantment, Integer>();
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            ItemStack stack = this.getStackInSlot(slot);
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            for (Map.Entry entry : enchantments.entrySet()) {
                Integer level = (Integer)storedEnchantments.get(entry.getKey());
                if (level != null && (Integer)entry.getValue() <= level) continue;
                storedEnchantments.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
            }
        }
        return storedEnchantments;
    }

    default public boolean isEffectIn(IEnchantEffect effect, Map<Enchantment, Integer> collection) {
        for (Map.Entry<Enchantment, Integer> entry : collection.entrySet()) {
            if (effect.origin() != entry.getKey() || effect.level() != entry.getValue().intValue()) continue;
            return true;
        }
        return false;
    }

    default public void updateEffects() {
        if (this.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        Map<Enchantment, Integer> storedEnchantments = this.getStoredEnchantments();
        HashSet<Enchantment> currentEnchantments = new HashSet<Enchantment>();
        List<IEnchantEffect> enchants = this.getEnchants();
        for (int i = enchants.size() - 1; i >= 0; --i) {
            IEnchantEffect effect = enchants.get(i);
            if (!this.isEffectIn(effect, storedEnchantments)) {
                effect.onRemoved();
                enchants.remove(i);
                continue;
            }
            currentEnchantments.add(effect.origin());
        }
        for (Map.Entry<Enchantment, Integer> entry : storedEnchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (currentEnchantments.contains(enchantment)) continue;
            List<IEffectSupplier> effects = EnchantabilityApi.getInstance().getEnchantEffects(enchantment);
            for (IEffectSupplier effectSupplier : effects) {
                IEnchantEffect effect = effectSupplier.create(this.getPlayer(), enchantment, entry.getValue());
                effect.onApplied();
                enchants.add(effect);
            }
        }
    }

    public boolean isDirty();

    public void markDirty(boolean var1);

    public CompoundNBT serializeEffects(CompoundNBT var1);

    public void deserializeEffects(CompoundNBT var1);
}

