/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.mod.common.util.ModRef;

public class ModConfig {
    public ForgeConfigSpec.BooleanValue enableAirWalker;
    public ForgeConfigSpec.BooleanValue enableBlastResist;
    public ForgeConfigSpec.BooleanValue enableDeflection;
    public ForgeConfigSpec.BooleanValue enableDexterity;
    public ForgeConfigSpec.BooleanValue enableFarReach;
    public ForgeConfigSpec.BooleanValue enableFastBreak;
    public ForgeConfigSpec.BooleanValue enableFirePraise;
    public ForgeConfigSpec.BooleanValue enableGluttony;
    public ForgeConfigSpec.BooleanValue enableGravity;
    public ForgeConfigSpec.BooleanValue enableSmite;
    public ForgeConfigSpec.BooleanValue enableVoid;
    public ForgeConfigSpec.BooleanValue enableCookie;
    public ForgeConfigSpec.BooleanValue enableRabbitStew;
    public ForgeConfigSpec.ConfigValue<List<String>> dexterityTags;
    public ForgeConfigSpec.ConfigValue<List<String>> dexterityItems;
    private static ModConfig instance;

    public static ModConfig get() {
        return instance;
    }

    public static void init(ForgeConfigSpec.Builder builder) {
        instance = new ModConfig(builder);
    }

    public ModConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Enabled Features").push("features");
        this.enableAirWalker = builder.define("enableAirWalker", true);
        this.enableBlastResist = builder.define("enableBlastResist", true);
        this.enableDeflection = builder.define("enableDeflection", true);
        this.enableDexterity = builder.define("enableDexterity", true);
        this.enableFarReach = builder.define("enableFarReach", true);
        this.enableFastBreak = builder.define("enableFastBreak", true);
        this.enableFirePraise = builder.define("enableFirePraise", true);
        this.enableGluttony = builder.define("enableGluttony", true);
        this.enableGravity = builder.define("enableGravity", true);
        this.enableSmite = builder.define("enableSmite", true);
        this.enableVoid = builder.define("enableVoid", true);
        builder.pop();
        builder.comment("Enchant Configs").push("enchants");
        builder.comment("Dexterity");
        this.dexterityTags = builder.define("dexterityTags", ModConfig.defaultTags());
        this.dexterityItems = builder.define("dexterityItems", ModConfig.defaultItems());
        builder.comment("Gluttony");
        this.enableRabbitStew = builder.define("enableRabbitStew", true);
        this.enableCookie = builder.define("enableCookie", true);
        builder.pop();
    }

    public void reloadTags() {
        for (String itemName : (List)this.dexterityItems.get()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
            if (item != null) {
                EnchantabilityApi.getInstance().addToDexterityList(item);
                continue;
            }
            ModRef.LOGGER.warn("Registered item for dexterity doesn't exist, " + itemName);
        }
        for (String tagName : (List)this.dexterityTags.get()) {
            Tag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(tagName));
            if (tag != null) {
                EnchantabilityApi.getInstance().addToDexterityList(tag);
                continue;
            }
            ModRef.LOGGER.warn("Registered tag for dexterity doesn't exist, " + tagName);
        }
    }

    private static List<String> defaultTags() {
        Tag[] tags = new Tag[]{Tags.Items.SANDSTONE, Tags.Items.RODS_WOODEN, ItemTags.field_219772_G, Tags.Items.DYES, ItemTags.field_199905_b, ItemTags.field_219776_M, ItemTags.field_219773_J, ItemTags.field_219770_E, ItemTags.field_200034_d, ItemTags.field_202900_j, ItemTags.field_203444_y, Tags.Items.CHESTS, Tags.Items.LEATHER};
        return Arrays.stream(tags).map(tag -> tag.func_199886_b().toString()).collect(Collectors.toList());
    }

    private static List<String> defaultItems() {
        Item[] items = new Item[]{Items.field_151059_bz, Items.field_151102_aT, Items.field_196153_dF, Items.field_151025_P};
        return Arrays.stream(items).map(item -> item.getRegistryName().toString()).collect(Collectors.toList());
    }
}

