/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.enchants;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.api.IEffectComponent;
import quarris.enchantability.api.IEffectSupplier;
import quarris.enchantability.api.enchants.IEnchantEffect;

public class EnchantEffectRegistry {
    public static final ListMultimap<Enchantment, ResourceLocation> BY_ENCHANTMENT = ArrayListMultimap.create();
    public static final Map<ResourceLocation, IEffectSupplier> BY_NAME = new HashMap<ResourceLocation, IEffectSupplier>();
    public static final Map<ResourceLocation, ITextComponent> DESCRIPTIONS = new HashMap<ResourceLocation, ITextComponent>();
    public static final Table<ResourceLocation, Class<? extends Event>, IEffectComponent<? extends IEnchantEffect, ? extends Event>> COMPONENTS = HashBasedTable.create();

    public static void register(ResourceLocation name, Enchantment enchantment, IEffectSupplier effect) {
        BY_ENCHANTMENT.put((Object)enchantment, (Object)name);
        BY_NAME.put(name, effect);
        DESCRIPTIONS.put(name, (ITextComponent)new TranslationTextComponent(name.toString() + ".enchant.desc", new Object[0]));
    }

    public static void register(ResourceLocation name, Enchantment enchantment, ITextComponent description, IEffectSupplier effect) {
        BY_ENCHANTMENT.put((Object)enchantment, (Object)name);
        BY_NAME.put(name, effect);
        DESCRIPTIONS.put(name, description);
    }

    public static List<IEffectSupplier> getEffects(Enchantment enchantment) {
        return BY_ENCHANTMENT.get((Object)enchantment).stream().map(BY_NAME::get).collect(Collectors.toList());
    }

    public static IEffectSupplier getEffect(ResourceLocation name) {
        return BY_NAME.get(name);
    }

    public static <F extends IEnchantEffect, T extends Event> void registerComponent(final ResourceLocation name, Class<T> eventClass, IEffectComponent<F, T> component, final Function<T, Collection<PlayerEntity>> playerGetter) {
        COMPONENTS.put((Object)name, eventClass, component);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, eventClass, new Consumer<T>(){
            private Function<T, Collection<PlayerEntity>> getPlayer;
            {
                this.getPlayer = playerGetter;
            }

            @Override
            public void accept(T event) {
                Collection<PlayerEntity> players = this.getPlayer.apply(event);
                if (players != null) {
                    players.stream().filter(Objects::nonNull).forEach(player -> player.getCapability(EnchantabilityApi.playerEnchant).ifPresent(cap -> {
                        if (event instanceof ExplosionEvent.Detonate) {
                            System.out.println(cap.getEnchants());
                        }
                        for (IEnchantEffect effect : cap.getEnchants()) {
                            if (!effect.getName().equals((Object)name)) continue;
                            for (Map.Entry entry : COMPONENTS.row((Object)name).entrySet()) {
                                IEffectComponent comp;
                                if (!((Class)entry.getKey()).isAssignableFrom(event.getClass()) || (comp = (IEffectComponent)COMPONENTS.get((Object)effect.getName(), entry.getKey())) == null) continue;
                                comp.run(effect, event);
                            }
                        }
                    }));
                }
            }
        });
    }
}

