/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.api.capabilities.IPlayerEnchant;
import quarris.enchantability.mod.ModConfig;
import quarris.enchantability.mod.common.capabilities.PlayerEnchant;
import quarris.enchantability.mod.common.network.EnderChestInteractPacket;
import quarris.enchantability.mod.common.network.PacketHandler;
import quarris.enchantability.mod.common.network.SyncClientPacket;
import quarris.enchantability.mod.common.util.ModRef;

@Mod.EventBusSubscriber(modid="enchantability")
public class CommonEvents {
    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(ModRef.createRes("enchant"), (ICapabilityProvider)new PlayerEnchant((PlayerEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void openEnderChestContainer(PlayerContainerEvent.Open event) {
        ChestContainer cont;
        if (event.getContainer() instanceof ChestContainer && (cont = (ChestContainer)event.getContainer()).func_85151_d() instanceof EnderChestInventory) {
            PacketHandler.INSTANCE.sendTo((Object)new EnderChestInteractPacket(true), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void closeEnderChestContainer(PlayerContainerEvent.Close event) {
        ChestContainer cont;
        if (event.getContainer() instanceof ChestContainer && (cont = (ChestContainer)event.getContainer()).func_85151_d() instanceof EnderChestInventory) {
            PacketHandler.INSTANCE.sendTo((Object)new EnderChestInteractPacket(false), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void reloadTags(TagsUpdatedEvent event) {
        ModConfig.get().reloadTags();
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            player.getCapability(EnchantabilityApi.playerEnchant).ifPresent(cap -> {
                if (cap.isDirty()) {
                    cap.updateEffects();
                    cap.markDirty(false);
                    PacketHandler.INSTANCE.sendTo((Object)new SyncClientPacket(cap.serializeEffects(new CompoundNBT())), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        event.getPlayer().getCapability(EnchantabilityApi.playerEnchant).ifPresent(cap -> PacketHandler.INSTANCE.sendTo((Object)new SyncClientPacket(cap.serializeEffects(new CompoundNBT())), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT));
    }

    @SubscribeEvent
    public static void cloneCapabilities(PlayerEvent.Clone e) {
        try {
            IPlayerEnchant original = (IPlayerEnchant)e.getOriginal().getCapability(EnchantabilityApi.playerEnchant).orElse(null);
            CompoundNBT nbt = (CompoundNBT)original.serializeNBT();
            IPlayerEnchant clone = (IPlayerEnchant)e.getPlayer().getCapability(EnchantabilityApi.playerEnchant).orElse(null);
            clone.deserializeNBT((INBT)nbt);
        }
        catch (Exception exp) {
            ModRef.LOGGER.warn("Failed to clone player " + e.getOriginal().func_200200_C_(), (Throwable)exp);
        }
    }
}

