/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.client;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ChestScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import quarris.enchantability.mod.client.screen.EnchButton;
import quarris.enchantability.mod.common.content.WitherHeartItem;
import quarris.enchantability.mod.common.enchants.EnchantEffectRegistry;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="enchantability")
public class ClientEvents {
    public static boolean isEnderOpen;
    public static double clickMouseX;
    public static double clickMouseY;

    @SubscribeEvent
    public static void addEnchantButton(GuiScreenEvent.InitGuiEvent.Post event) {
        if (isEnderOpen && event.getGui() instanceof ChestScreen) {
            ChestScreen screen = (ChestScreen)event.getGui();
            event.addWidget((Widget)new EnchButton(screen.getGuiLeft() - 18, screen.getGuiTop() + 143, false));
        }
    }

    @SubscribeEvent
    public static void addEnchantTooltips(ItemTooltipEvent event) {
        if (!(event.getItemStack().func_77973_b() instanceof EnchantedBookItem)) {
            return;
        }
        ItemStack stack = event.getItemStack();
        PlayerEntity player = event.getPlayer();
        ArrayList tooltips = new ArrayList();
        Set enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet();
        for (Enchantment enchantment : enchantments) {
            tooltips.addAll(EnchantEffectRegistry.BY_ENCHANTMENT.get((Object)enchantment).stream().map(EnchantEffectRegistry.DESCRIPTIONS::get).collect(Collectors.toList()));
        }
        if (tooltips.isEmpty()) {
            event.getToolTip().add(new TranslationTextComponent("enchant.desc.empty", new Object[0]).func_211708_a(TextFormatting.GRAY));
            return;
        }
        if (player == null) {
            event.getToolTip().add(new StringTextComponent("Enchantability:"));
            for (ITextComponent tooltip : tooltips) {
                StringTextComponent text = new StringTextComponent(" - ");
                text.func_150257_a(tooltip);
                event.getToolTip().add(text);
            }
        } else if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340)) {
            event.getToolTip().add(new StringTextComponent("Enchantability:").func_211708_a(TextFormatting.GOLD));
            for (ITextComponent tooltip : tooltips) {
                ITextComponent text = new StringTextComponent(" - ").func_211708_a(TextFormatting.BLUE);
                text.func_150257_a(tooltip);
                event.getToolTip().add(text);
            }
        } else {
            event.getToolTip().add(new TranslationTextComponent("enchant.desc.short", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    @SubscribeEvent
    public static void setTooltips(ItemTooltipEvent event) {
        TranslationTextComponent translation;
        ItemStack item = event.getItemStack();
        if (item.func_77973_b() != WitherHeartItem.WITHER_HEART) {
            return;
        }
        if (item.func_77978_p() == null || event.getPlayer() == null) {
            translation = new TranslationTextComponent("wither_heart.tooltip.no_owner", new Object[0]);
        } else {
            UUID ownerUUID;
            UUID uUID = ownerUUID = item.func_77978_p().func_74764_b("Owner") ? item.func_77978_p().func_186857_a("Owner") : null;
            String ownerName = item.func_77978_p().func_74764_b("OwnerName") ? item.func_77978_p().func_74779_i("OwnerName") : "Unknown" + (ownerUUID == null ? "" : "{" + ownerUUID + "}");
            translation = new TranslationTextComponent("wither_heart.tooltip.heart_owner", new Object[]{ownerName});
        }
        event.getToolTip().add(new TranslationTextComponent("wither_heart.tooltip.only_worthy", new Object[0]).func_211708_a(TextFormatting.RED));
        event.getToolTip().add(translation.func_211708_a(TextFormatting.WHITE));
    }
}

