/*
 * Decompiled with CFR 0.152.
 */
package quarris.enchantability.mod.common.enchants;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import quarris.enchantability.api.EnchantabilityApi;
import quarris.enchantability.api.IEffectComponent;
import quarris.enchantability.api.IEffectSupplier;
import quarris.enchantability.api.enchants.IEnchantEffect;
import quarris.enchantability.mod.Enchantability;
import quarris.enchantability.mod.ModConfig;
import quarris.enchantability.mod.common.enchants.impl.AirWalkerEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.BlastResistanceEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.DeflectionEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.DexterityEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.FarReachEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.FastBreakEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.FirePraiseEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.GluttonyEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.GluttonyFoods;
import quarris.enchantability.mod.common.enchants.impl.GravityEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.HeatEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.SmiteEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.StrikeEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.SwiftChargeEnchantEffect;
import quarris.enchantability.mod.common.enchants.impl.VoidEnchantEffect;

public class Enchants {
    public static void registerEffect() {
        ModConfig config = ModConfig.get();
        if (((Boolean)config.enableFarReach.get()).booleanValue()) {
            Enchants.registerEffect(FarReachEnchantEffect.NAME, Enchantments.field_180313_o, FarReachEnchantEffect::new);
        }
        if (((Boolean)config.enableFastBreak.get()).booleanValue()) {
            Enchants.registerEffect(FastBreakEnchantEffect.NAME, Enchantments.field_185310_v, FastBreakEnchantEffect::new);
        }
        if (((Boolean)config.enableGravity.get()).booleanValue()) {
            Enchants.registerEffect(GravityEnchantEffect.NAME, Enchantments.field_180309_e, GravityEnchantEffect::new);
        }
        if (((Boolean)config.enableDeflection.get()).booleanValue()) {
            Enchants.registerEffect(DeflectionEnchantEffect.NAME, Enchantments.field_180308_g, DeflectionEnchantEffect::new);
        }
        if (((Boolean)config.enableVoid.get()).booleanValue()) {
            Enchants.registerEffect(VoidEnchantEffect.NAME, Enchantments.field_185312_x, VoidEnchantEffect::new);
        }
        if (((Boolean)config.enableBlastResist.get()).booleanValue()) {
            Enchants.registerEffect(BlastResistanceEnchantEffect.NAME, Enchantments.field_185297_d, BlastResistanceEnchantEffect::new);
        }
        if (((Boolean)config.enableFirePraise.get()).booleanValue()) {
            Enchants.registerEffect(FirePraiseEnchantEffect.NAME, Enchantments.field_77334_n, FirePraiseEnchantEffect::new);
        }
        if (((Boolean)config.enableAirWalker.get()).booleanValue()) {
            Enchants.registerEffect(AirWalkerEnchantEffect.NAME, Enchantments.field_185301_j, AirWalkerEnchantEffect::new);
        }
        if (((Boolean)config.enableGluttony.get()).booleanValue()) {
            Enchants.registerEffect(GluttonyEnchantEffect.NAME, Enchantments.field_185296_A, GluttonyEnchantEffect::new);
        }
        if (((Boolean)config.enableDexterity.get()).booleanValue()) {
            Enchants.registerEffect(DexterityEnchantEffect.NAME, Enchantments.field_185305_q, DexterityEnchantEffect::new);
        }
        if (((Boolean)config.enableSmite.get()).booleanValue()) {
            Enchants.registerEffect(SmiteEnchantEffect.NAME, Enchantments.field_185303_l, SmiteEnchantEffect::new);
        }
        if (((Boolean)config.enableStrike.get()).booleanValue()) {
            Enchants.registerEffect(StrikeEnchantEffect.NAME, Enchantments.field_185309_u, StrikeEnchantEffect::new);
        }
        if (((Boolean)config.enableSwiftCharge.get()).booleanValue()) {
            Enchants.registerEffect(SwiftChargeEnchantEffect.NAME, Enchantments.field_222193_H, SwiftChargeEnchantEffect::new);
        }
        if (((Boolean)config.enableHeat.get()).booleanValue()) {
            Enchants.registerEffect(HeatEnchantEffect.NAME, Enchantments.field_185311_w, HeatEnchantEffect::new);
        }
        Enchantability.proxy.registerClientComponents();
        if (((Boolean)config.enableFastBreak.get()).booleanValue()) {
            Enchants.registerComponent(FastBreakEnchantEffect.NAME, PlayerEvent.BreakSpeed.class, FastBreakEnchantEffect::handBreak, e -> Collections.singleton(e.getPlayer()));
        }
        if (((Boolean)config.enableDeflection.get()).booleanValue()) {
            Enchants.registerComponent(DeflectionEnchantEffect.NAME, ProjectileImpactEvent.class, DeflectionEnchantEffect::deflect, e -> {
                if (e.getRayTraceResult() instanceof EntityRayTraceResult && ((EntityRayTraceResult)e.getRayTraceResult()).func_216348_a() instanceof PlayerEntity) {
                    return Collections.singleton((PlayerEntity)((EntityRayTraceResult)e.getRayTraceResult()).func_216348_a());
                }
                return null;
            });
        }
        if (((Boolean)config.enableDexterity.get()).booleanValue()) {
            Enchants.registerComponent(DexterityEnchantEffect.NAME, PlayerEvent.ItemCraftedEvent.class, DexterityEnchantEffect::craft, e -> Collections.singleton(e.getPlayer()));
        }
        if (((Boolean)config.enableVoid.get()).booleanValue()) {
            Enchants.registerComponent(VoidEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, VoidEnchantEffect::voidTeleport, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableSmite.get()).booleanValue()) {
            Enchants.registerComponent(SmiteEnchantEffect.NAME, AttackEntityEvent.class, SmiteEnchantEffect::smite, e -> Collections.singleton(e.getPlayer()));
        }
        if (((Boolean)config.enableBlastResist.get()).booleanValue()) {
            Enchants.registerComponent(BlastResistanceEnchantEffect.NAME, ExplosionEvent.Detonate.class, BlastResistanceEnchantEffect::resistBlast, evt -> evt.getAffectedEntities().stream().filter(entity -> entity instanceof PlayerEntity).map(entity -> (PlayerEntity)entity).collect(Collectors.toList()));
        }
        if (((Boolean)config.enableFirePraise.get()).booleanValue()) {
            Enchants.registerComponent(FirePraiseEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, FirePraiseEnchantEffect::praiseTheSun, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableAirWalker.get()).booleanValue()) {
            Enchants.registerComponent(AirWalkerEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, AirWalkerEnchantEffect::airWalk, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableGluttony.get()).booleanValue()) {
            Enchants.registerComponent(GluttonyEnchantEffect.NAME, LivingEntityUseItemEvent.Finish.class, GluttonyEnchantEffect::consume, e -> e.getEntity() instanceof PlayerEntity ? Collections.singleton((PlayerEntity)e.getEntity()) : Collections.emptyList());
            GluttonyFoods.initMendingFoods();
        }
        if (((Boolean)config.enableSwiftCharge.get()).booleanValue()) {
            Enchants.registerComponent(SwiftChargeEnchantEffect.NAME, LivingEntityUseItemEvent.Start.class, SwiftChargeEnchantEffect::itemUse, e -> {
                if (e.getEntity() instanceof PlayerEntity) {
                    return Collections.singleton((PlayerEntity)e.getEntity());
                }
                return Collections.emptyList();
            });
            Enchants.registerComponent(SwiftChargeEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, SwiftChargeEnchantEffect::transition, e -> Collections.singleton(e.player));
        }
        if (((Boolean)config.enableStrike.get()).booleanValue()) {
            Enchants.registerComponent(StrikeEnchantEffect.NAME, LivingHurtEvent.class, StrikeEnchantEffect::strike, e -> {
                if (e.getSource().field_76373_n.equals("player")) {
                    return Collections.singleton((PlayerEntity)e.getSource().func_76346_g());
                }
                return Collections.emptyList();
            });
        }
        if (((Boolean)config.enableHeat.get()).booleanValue()) {
            Enchants.registerComponent(HeatEnchantEffect.NAME, TickEvent.PlayerTickEvent.class, HeatEnchantEffect::heat, e -> Collections.singleton(e.player));
        }
    }

    private static void registerEffect(ResourceLocation name, Enchantment enchantment, IEffectSupplier effectSupplier) {
        EnchantabilityApi.getInstance().registerEnchantEffect(name, enchantment, effectSupplier);
    }

    private static <F extends IEnchantEffect, T extends Event> void registerComponent(ResourceLocation name, Class<T> eventClass, IEffectComponent<F, T> component, Function<T, Collection<PlayerEntity>> playerGetter) {
        EnchantabilityApi.getInstance().registerEffectComponent(name, eventClass, component, playerGetter);
    }
}

