/*
 * Decompiled with CFR 0.152.
 */
package com.polyvalord.extlights.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockCandle
extends Block {
    public static final int MAXCANDLES = 5;
    public static final IntegerProperty CANDLES = IntegerProperty.func_177719_a((String)"candles", (int)1, (int)5);
    protected static final VoxelShape SHAPE_ONE = Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5);
    protected static final VoxelShape SHAPE_TWO = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)8.5, (double)0.0, (double)7.5, (double)11.5, (double)5.0, (double)10.5), (VoxelShape)Block.func_208617_a((double)4.5, (double)0.0, (double)5.5, (double)7.5, (double)5.0, (double)8.5));
    protected static final VoxelShape SHAPE_THREE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)8.5, (double)0.0, (double)9.5, (double)11.5, (double)5.0, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)4.5, (double)0.0, (double)7.5, (double)7.5, (double)5.0, (double)10.5), Block.func_208617_a((double)6.5, (double)0.0, (double)3.5, (double)9.5, (double)5.0, (double)6.5)});
    protected static final VoxelShape SHAPE_FOUR = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)3.5, (double)0.0, (double)7.5, (double)6.5, (double)5.0, (double)10.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)7.5, (double)0.0, (double)9.5, (double)10.5, (double)5.0, (double)12.5), Block.func_208617_a((double)9.5, (double)0.0, (double)5.5, (double)12.5, (double)5.0, (double)8.5), Block.func_208617_a((double)5.5, (double)0.0, (double)3.5, (double)8.5, (double)5.0, (double)6.5)});
    protected static final VoxelShape SHAPE_FIVE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.5, (double)0.0, (double)8.5, (double)5.5, (double)5.0, (double)11.5), Block.func_208617_a((double)8.5, (double)0.0, (double)10.5, (double)11.5, (double)5.0, (double)13.5), Block.func_208617_a((double)10.5, (double)0.0, (double)4.5, (double)13.5, (double)5.0, (double)7.5), Block.func_208617_a((double)4.5, (double)0.0, (double)2.5, (double)7.5, (double)5.0, (double)5.5)});

    public BlockCandle(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)CANDLES, (Comparable)Integer.valueOf(1)));
    }

    public int func_149750_m(BlockState state) {
        return this.field_149784_t + 1 * (Integer)state.func_177229_b((IProperty)CANDLES);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_177230_c() == this) {
            return (BlockState)blockstate.func_206870_a((IProperty)CANDLES, (Comparable)Integer.valueOf(Math.min(5, (Integer)blockstate.func_177229_b((IProperty)CANDLES) + 1)));
        }
        return this.func_176223_P();
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return !state.func_196952_d(worldIn, pos).func_212434_a(Direction.UP).func_197766_b();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((IProperty)CANDLES) < 5 ? true : super.func_196253_a(state, useContext);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Integer)state.func_177229_b((IProperty)CANDLES)) {
            default: {
                return SHAPE_ONE;
            }
            case 2: {
                return SHAPE_TWO;
            }
            case 3: {
                return SHAPE_THREE;
            }
            case 4: {
                return SHAPE_FOUR;
            }
            case 5: 
        }
        return SHAPE_FIVE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CANDLES});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int quant = (Integer)stateIn.func_177229_b((IProperty)CANDLES);
        double d0 = pos.func_177958_n();
        double d1 = (double)pos.func_177956_o() + 0.5;
        double d2 = pos.func_177952_p();
        double[] xPos = new double[quant];
        double[] zPos = new double[quant];
        switch (quant) {
            case 1: {
                xPos[0] = 8.0;
                zPos[0] = 8.0;
                break;
            }
            case 2: {
                xPos[0] = 10.0;
                zPos[0] = 9.0;
                xPos[1] = 6.0;
                zPos[1] = 7.0;
                break;
            }
            case 3: {
                xPos[0] = 10.0;
                zPos[0] = 11.0;
                xPos[1] = 6.0;
                zPos[1] = 9.0;
                xPos[2] = 8.0;
                zPos[2] = 5.0;
                break;
            }
            case 4: {
                xPos[0] = 5.0;
                zPos[0] = 9.0;
                xPos[1] = 9.0;
                zPos[1] = 11.0;
                xPos[2] = 11.0;
                zPos[2] = 7.0;
                xPos[3] = 7.0;
                zPos[3] = 5.0;
                break;
            }
            case 5: {
                xPos[0] = 8.0;
                zPos[0] = 8.0;
                xPos[1] = 4.0;
                zPos[1] = 10.0;
                xPos[2] = 10.0;
                zPos[2] = 12.0;
                xPos[3] = 12.0;
                zPos[3] = 6.0;
                xPos[4] = 6.0;
                zPos[4] = 4.0;
            }
        }
        for (int i = 0; i < quant; ++i) {
            boolean n = rand.nextBoolean();
            n = true;
            if (!n) continue;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + xPos[i] * 0.0625, d1, d2 + zPos[i] * 0.0625, 0.0, 0.01, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + xPos[i] * 0.0625, d1, d2 + zPos[i] * 0.0625, 0.0, 0.01, 0.0);
        }
    }
}

