/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import zabi.minecraft.extraalchemy.config.ConfigInstance;

public class ModConfig {
    private static File folder = new File("config");
    private static File configFile;
    private static Gson config;
    public static ConfigInstance INSTANCE;

    public static void init() {
        ModConfig.loadDefaults();
        ModConfig.generateFoldersAndFiles();
        ModConfig.readJson();
    }

    public static void loadDefaults() {
        INSTANCE = new ConfigInstance();
    }

    private static void generateFoldersAndFiles() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            configFile = new File(folder, "extraalchemy.json");
            if (!configFile.exists()) {
                try {
                    configFile.createNewFile();
                    ModConfig.loadDefaults();
                    String json = config.toJson((Object)INSTANCE);
                    FileWriter writer = new FileWriter(configFile);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't create config file", e);
                }
            } else if (configFile.isDirectory()) {
                throw new IllegalStateException("'extraalchemy.json' must be a file!");
            }
        } else {
            throw new IllegalStateException("'config' must be a folder!");
        }
    }

    public static void readJson() {
        try {
            INSTANCE = (ConfigInstance)config.fromJson((Reader)new FileReader(configFile), ConfigInstance.class);
            if (INSTANCE == null) {
                throw new IllegalStateException("Null configuration");
            }
        }
        catch (JsonSyntaxException e) {
            System.err.println("Invalid configuration!");
            e.printStackTrace();
        }
        catch (JsonIOException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    static {
        config = new GsonBuilder().setPrettyPrinting().create();
    }
}

