/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.items;

import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.container.ContainerProviderRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2572;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import zabi.minecraft.extraalchemy.items.ItemSettings;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.screen.ModContainerTypes;
import zabi.minecraft.extraalchemy.utils.Log;

public class PotionBagItem
extends class_1792 {
    public static final String TAG_MODE = "ea_select_mode";
    public static final String TAG_INVENTORY = "ea_inventory";
    public static final String TAG_SELECTED = "ea_selected";

    public PotionBagItem() {
        super(new class_1792.class_1793().method_7889(1).method_7892(ItemSettings.EXTRA_ALCHEMY_GROUP));
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        Optional<class_1842> optpot = this.getSelectedPotion(stack);
        if (optpot.isPresent()) {
            int avail = this.getSelectedPotionAmount(stack).get();
            class_2561 potion = new class_2588(optpot.get().method_8051("item.minecraft.potion.effect."), new Object[0]).method_10856(new class_124[]{class_124.field_1064, class_124.field_1067});
            class_2561 amount = new class_2585("" + avail).method_10854(class_124.field_1078);
            tooltip.add((class_2561)new class_2588("item.extraalchemy.potion_bag.selected.potion", new Object[]{potion, amount}));
        } else {
            tooltip.add(new class_2588("item.extraalchemy.potion_bag.selected.none", new Object[0]).method_10854(class_124.field_1079));
        }
        class_2561 option = new class_2588("item.extraalchemy.potion_bag.autoselect.option." + this.getSelectionMode(stack).toString().toLowerCase(), new Object[0]).method_10854(class_124.field_1065);
        tooltip.add((class_2561)new class_2588("item.extraalchemy.potion_bag.autoselect", new Object[]{option}));
        tooltip.add((class_2561)new class_2588("item.extraalchemy.potion_bag.autoselect.change", new Object[]{new class_2572("key.extraalchemy.potion_bag_mode").method_10854(class_124.field_1075)}));
        if (optpot.isPresent()) {
            tooltip.add((class_2561)new class_2585(""));
            class_1844.method_8065((class_1799)class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)optpot.get()), tooltip, (float)1.0f);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            if (user.method_5715()) {
                ContainerProviderRegistry.INSTANCE.openContainer(ModContainerTypes.POTION_BAG, user, buf -> buf.writeBoolean(hand == class_1268.field_5808));
            } else {
                this.handleRefill(stack);
                Optional<class_1842> optpot = this.getSelectedPotion(stack);
                if (this.getSelectedPotionAmount(stack).get() > 0 && optpot.isPresent()) {
                    user.method_6019(hand);
                }
                user.field_7514.method_5431();
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    private void handleRefill(class_1799 stack) {
        if (this.getSelectedPotionAmount(stack).get() == 0) {
            switch (this.getSelectionMode(stack)) {
                case DESELECT: {
                    this.selectPotion(stack, null);
                    break;
                }
                case NEXT: {
                    this.getFirstAvailablePotion(stack).ifPresent(potionStack -> this.selectPotion(stack, (class_1799)potionStack));
                    break;
                }
            }
        }
    }

    private void selectPotion(class_1799 bag, class_1799 potionStack) {
        if (potionStack == null) {
            bag.method_7948().method_10551(TAG_SELECTED);
        } else {
            class_2487 potionTag = new class_2487();
            potionTag.method_10582("Potion", class_2378.field_11143.method_10221((Object)class_1844.method_8063((class_1799)potionStack)).toString());
            bag.method_7948().method_10566(TAG_SELECTED, (class_2520)potionTag);
        }
    }

    public class_1799 method_7861(class_1799 bag, class_1937 world, class_1309 user) {
        if (!world.field_9236 && user instanceof class_1657) {
            Optional<class_1842> potopt = this.getSelectedPotion(bag);
            if (potopt.isPresent()) {
                class_1842 target = potopt.get();
                BagInventory inv = new BagInventory(bag, user.method_6058());
                this.findPotionAndApply(user, target, inv);
            }
            ((class_1657)user).method_7357().method_7906((class_1792)this, 20);
        }
        return super.method_7861(bag, world, user);
    }

    private void findPotionAndApply(class_1309 user, class_1842 target, BagInventory inv) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 currentStack = inv.method_5438(i);
            class_1842 isp = class_1844.method_8063((class_1799)currentStack);
            if (!isp.equals(target) || currentStack.method_7909() == class_1802.field_8162) continue;
            currentStack.method_7934(1);
            for (class_1293 sei : target.method_8049()) {
                user.method_6092(new class_1293(sei.method_5579(), sei.method_5584(), sei.method_5578(), false, false, true));
            }
            inv.method_5432((class_1657)user);
            ((class_1657)user).field_7514.method_5431();
            break;
        }
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 20;
    }

    public boolean method_7886(class_1799 stack) {
        return this.getSelectedPotion(stack).isPresent();
    }

    public Optional<class_1842> getSelectedPotion(class_1799 bag) {
        class_1842 pot = class_1844.method_8057((class_2487)bag.method_7948().method_10562(TAG_SELECTED));
        if (pot.method_8049().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(pot);
    }

    public Optional<Integer> getSelectedPotionAmount(class_1799 bag) {
        int count = 0;
        Optional<class_1842> potopt = this.getSelectedPotion(bag);
        if (potopt.isPresent()) {
            BagInventory inv = new BagInventory(bag, null);
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1842 isp = class_1844.method_8063((class_1799)inv.method_5438(i));
                if (!isp.equals(potopt.get()) || inv.method_5438(i).method_7909() == class_1802.field_8162) continue;
                ++count;
            }
        }
        return Optional.of(count);
    }

    public SelectionMode getSelectionMode(class_1799 bag) {
        return SelectionMode.values()[bag.method_7948().method_10550(TAG_MODE) % SelectionMode.values().length];
    }

    public static void toggleStatusForPlayer(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == ModItems.POTION_BAG) {
            int current_mode = stack.method_7948().method_10550(TAG_MODE);
            stack.method_7969().method_10569(TAG_MODE, (current_mode + 1) % SelectionMode.values().length);
            player.field_7514.method_5431();
        } else {
            Log.w("Not holding a bag");
        }
    }

    public Optional<class_1799> getFirstAvailablePotion(class_1799 stack) {
        BagInventory inv = new BagInventory(stack, null);
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 currentStack = inv.method_5438(i);
            class_1842 isp = class_1844.method_8063((class_1799)currentStack);
            if (isp.method_8049().isEmpty() || currentStack.method_7909() == class_1802.field_8162) continue;
            return Optional.of(currentStack.method_7972());
        }
        return Optional.empty();
    }

    public static enum SelectionMode {
        HOLD,
        NEXT,
        DESELECT;

    }

    public static class BagInventory
    implements class_1263 {
        private static final int SLOT_AMOUNT = 18;
        private class_2371<class_1799> inventory = class_2371.method_10213((int)18, (Object)class_1799.field_8037);
        private class_1268 openedWith;

        public BagInventory(class_1799 bag, class_1268 hand) {
            this.openedWith = hand;
            this.deserialize(bag.method_7948().method_10562(PotionBagItem.TAG_INVENTORY));
        }

        public void method_5448() {
            this.inventory.clear();
        }

        public int method_5439() {
            return 18;
        }

        public boolean method_5442() {
            return this.inventory.stream().allMatch(class_1799::method_7960);
        }

        public class_1799 method_5438(int slot) {
            return (class_1799)this.inventory.get(slot);
        }

        public class_1799 method_5434(int slot, int amount) {
            return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        }

        public class_1799 method_5441(int slot) {
            return class_1262.method_5428(this.inventory, (int)slot);
        }

        public void method_5447(int slot, class_1799 stack) {
            this.inventory.set(slot, (Object)stack);
        }

        public void method_5431() {
        }

        public boolean method_5443(class_1657 player) {
            if (this.openedWith == null) {
                return true;
            }
            return player.method_5998(this.openedWith).method_7909() instanceof PotionBagItem;
        }

        public void method_5432(class_1657 player) {
            if (this.openedWith != null) {
                player.method_5998(this.openedWith).method_7948().method_10566(PotionBagItem.TAG_INVENTORY, this.serialize(this.inventory));
            } else if (!player.field_6002.field_9236) {
                Log.w("Server did not have any hand info associated with the inventory");
            }
        }

        private class_2520 serialize(class_2371<class_1799> items) {
            class_2487 tag = new class_2487();
            for (int i = 0; i < items.size(); ++i) {
                tag.method_10566("inv" + i, (class_2520)((class_1799)items.get(i)).method_7953(new class_2487()));
            }
            return tag;
        }

        private void deserialize(class_2487 tag) {
            for (int i = 0; i < this.inventory.size(); ++i) {
                this.inventory.set(i, (Object)class_1799.method_7915((class_2487)tag.method_10562("inv" + i)));
            }
        }

        public boolean method_5437(int slot, class_1799 stack) {
            return !class_1844.method_8063((class_1799)stack).method_8049().isEmpty();
        }
    }
}

