/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.crafting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.class_1293;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import zabi.minecraft.extraalchemy.config.ModConfig;
import zabi.minecraft.extraalchemy.crafting.CraftingRecipes;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.items.PotionRingItem;
import zabi.minecraft.extraalchemy.utils.Log;

public class PotionRingRecipe
extends class_1852 {
    private int cost;
    private int length;
    private int renew;
    private class_1842 potion;

    public PotionRingRecipe(class_2960 id, int cost, int length, int renew, class_1842 potion) {
        super(id);
        this.cost = cost;
        this.length = length;
        this.potion = potion;
        this.renew = renew;
    }

    public boolean matches(class_1715 inv, class_1937 world) {
        if (!ModConfig.INSTANCE.enableRings || this.potion.method_8049().size() == 0) {
            return false;
        }
        boolean foundPotion = false;
        boolean foundRing = false;
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 is = inv.method_5438(i);
            class_1792 s = is.method_7909();
            if (s.equals(class_1802.field_8574)) {
                if (foundPotion || !class_1844.method_8063((class_1799)is).equals(this.potion)) {
                    return false;
                }
                foundPotion = true;
                continue;
            }
            if (s.equals((Object)ModItems.EMPTY_RING)) {
                if (foundRing) {
                    return false;
                }
                foundRing = true;
                continue;
            }
            if (s.equals(class_1802.field_8162)) continue;
            return false;
        }
        return foundRing && foundPotion;
    }

    public class_1799 craft(class_1715 inv) {
        class_1799 result = new class_1799((class_1935)ModItems.POTION_RING);
        class_1844.method_8061((class_1799)result, (class_1842)this.potion);
        result.method_7969().method_10569("cost", this.cost);
        result.method_7969().method_10569("length", this.length);
        result.method_7969().method_10569("renew", this.renew);
        result.method_7969().method_10556("disabled", true);
        return result;
    }

    public boolean method_8113(int width, int height) {
        return width > 1 || height > 1;
    }

    public class_1865<?> method_8119() {
        return CraftingRecipes.RING_CRAFTING_SERIALIZER;
    }

    public static void generateDefaults() {
        if ("true".equals(System.getProperty("devGenerateDefaultRingRecipes"))) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            File POTFOLDER = new File("POT_OUT");
            POTFOLDER.mkdir();
            class_2378.field_11143.method_29722().stream().map(e -> (class_1842)e.getValue()).filter(p -> p.method_8049().size() == 1).filter(p -> !p.method_8050()).filter(PotionRingItem.ignoreLongVersions()).forEach(pot -> {
                PotionJson en = new PotionJson((class_1842)pot);
                File out = new File(POTFOLDER, en.potion.replace(':', '_') + ".json");
                try (FileWriter fw = new FileWriter(out);){
                    fw.write(gson.toJson((Object)en));
                    Log.w("Generated: " + out.getName());
                }
                catch (IOException e1) {
                    Log.e("Not generated: " + out.getName());
                    e1.printStackTrace();
                }
            });
            throw new RuntimeException("Ring Potion Recipes generated in " + POTFOLDER.getAbsolutePath());
        }
    }

    public static class PotionJson {
        public int cost;
        public int length;
        public int renew;
        public String potion;
        public String type = "extraalchemy:potion_ring";

        public PotionJson(class_1842 potion) {
            class_1293 sei = (class_1293)potion.method_8049().get(0);
            this.cost = 2 * (sei.method_5578() + 1);
            this.length = 4 + sei.method_5584() / 200;
            this.renew = 1;
            this.potion = class_2378.field_11143.method_10221((Object)potion).toString();
        }
    }

    public static class Serializer
    implements class_1865<PotionRingRecipe> {
        public PotionRingRecipe read(class_2960 id, JsonObject json) {
            int cost = json.get("cost").getAsInt();
            int length = json.get("length").getAsInt();
            int renewTime = json.has("renew") ? json.get("renew").getAsInt() : 1;
            String potion_name = json.get("potion").getAsString();
            class_1842 pot = (class_1842)class_2378.field_11143.method_10223(new class_2960(potion_name));
            if (pot.method_8049().size() > 1) {
                Log.w("The ring recipe %s has more than 1 effect associated with it, this functionality is meant for 1-effect potions.");
            }
            if (pot.method_8049().stream().allMatch(sei -> sei.method_5579().method_5561())) {
                Log.w("The ring recipe %s has no non-instant effects associated with %s, this functionality is meant for long lasting effects.", id, potion_name);
            }
            return new PotionRingRecipe(id, cost, length, renewTime, pot);
        }

        public PotionRingRecipe read(class_2960 id, class_2540 buf) {
            int cost = buf.readInt();
            int length = buf.readInt();
            int renew = buf.readInt();
            String potion_name = buf.method_19772();
            class_1842 pot = (class_1842)class_2378.field_11143.method_10223(new class_2960(potion_name));
            return new PotionRingRecipe(id, cost, length, renew, pot);
        }

        public void write(class_2540 buf, PotionRingRecipe recipe) {
            buf.writeInt(recipe.cost);
            buf.writeInt(recipe.length);
            buf.writeInt(recipe.renew);
            buf.method_10814(class_2378.field_11143.method_10221((Object)recipe.potion).toString());
        }
    }
}

