/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.blocks.airdispersal;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.blocks.airdispersal.AirDispersal;
import com.theundertaker11.geneticsreborn.potions.GREntityPotion;
import com.theundertaker11.geneticsreborn.potions.ViralSplashPotion;
import com.theundertaker11.geneticsreborn.tile.GRTileEntityBasicEnergyReceiver;
import com.theundertaker11.geneticsreborn.util.CustomEnergyStorage;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GRTileEntityAirDispersal
extends GRTileEntityBasicEnergyReceiver
implements ITickable {
    public static final int OFF = 0;
    public static final int UNLOCKED = 1;
    public static final int LOCKED = 2;
    public static final int RUNNING = 3;
    private int timeLeft;
    private final Item[] lock = new Item[4];
    private int state;
    private ItemStackHandler guiStackHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            GRTileEntityAirDispersal.this.func_70296_d();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (GRTileEntityAirDispersal.this.state == 2 || GRTileEntityAirDispersal.this.state == 3) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private static final byte TIME_FIELD_ID = 3;
    private static final byte STATE_FIELD_ID = 4;

    public GRTileEntityAirDispersal() {
    }

    public GRTileEntityAirDispersal(String name) {
        this(name, false);
    }

    public GRTileEntityAirDispersal(String name, boolean a) {
        super(name);
        this.state = 0;
        this.storage = new CustomEnergyStorage(1000);
        this.NUMBER_OF_FIELDS = (byte)5;
    }

    public boolean isRunning() {
        return this.state == 3;
    }

    public int getState() {
        return this.state;
    }

    public int timeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(int ticks) {
        this.timeLeft = ticks;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public boolean isLocked() {
        return this.state == 2 || this.state == 3;
    }

    public void setLocked(boolean l) {
        if (!(!l || this.isPrimed() && this.hasPower())) {
            return;
        }
        int n = this.state = l ? 2 : 1;
        if (this.state == 2 && this.field_145850_b.func_175640_z(this.func_174877_v())) {
            this.state = 3;
        }
    }

    public void func_73660_a() {
        if (this.hasPower()) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a((IProperty)AirDispersal.MASKED, (Comparable)Boolean.valueOf(this.isLocked() && this.guiStackHandler.getStackInSlot(1) != ItemStack.field_190927_a)));
        }
        if (this.storage.getEnergyStored() == this.storage.getMaxEnergyStored() && this.state == 0) {
            this.state = 1;
        }
        if (this.state == 3) {
            --this.timeLeft;
            if (this.timeLeft <= 0) {
                this.throwPotion();
                this.func_70296_d();
            }
        }
    }

    public boolean hasPower() {
        return this.state != 0;
    }

    public boolean isPrimed() {
        return this.guiStackHandler.getStackInSlot(0) != ItemStack.field_190927_a;
    }

    public Item[] getLock() {
        return this.lock;
    }

    public void setLock(int pos, Item item) {
        this.lock[pos] = item;
    }

    public void throwPotion() {
        EntityPotion potion;
        if (!this.isPrimed()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.state = 0;
        this.timeLeft = 0;
        this.clearLock();
        this.storage.extractEnergy(1000, false);
        BlockPos pos = this.func_174877_v();
        ItemStack item = this.guiStackHandler.extractItem(0, 1, false);
        if (item.func_77973_b() instanceof ViralSplashPotion) {
            potion = new GREntityPotion(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.05, (double)pos.func_177952_p() + 0.5, GeneticsReborn.virusRange * 2.0f, item);
            EnumGenes gene = ViralSplashPotion.getGene(item);
            ((GREntityPotion)potion).setGene(gene);
        } else {
            potion = new EntityPotion(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, item);
        }
        this.field_145850_b.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187827_fP, SoundCategory.PLAYERS, 0.5f, 0.4f);
        potion.field_70159_w = 0.0;
        potion.field_70181_x = 0.6;
        potion.field_70179_y = 0.0;
        this.field_145850_b.func_72838_d((Entity)potion);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.guiStackHandler.serializeNBT());
        compound.func_74768_a("state", this.state);
        compound.func_74768_a("timeleft", this.timeLeft);
        compound.func_74778_a("lock0", this.lock[0] != null ? this.lock[0].getRegistryName().toString() : "");
        compound.func_74778_a("lock1", this.lock[1] != null ? this.lock[1].getRegistryName().toString() : "");
        compound.func_74778_a("lock2", this.lock[2] != null ? this.lock[2].getRegistryName().toString() : "");
        compound.func_74778_a("lock3", this.lock[3] != null ? this.lock[3].getRegistryName().toString() : "");
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.guiStackHandler.deserializeNBT(compound.func_74775_l("inventory"));
        this.state = compound.func_74762_e("state");
        this.timeLeft = compound.func_74762_e("timeleft");
        this.lock[0] = Item.func_111206_d((String)compound.func_74779_i("lock0"));
        this.lock[1] = Item.func_111206_d((String)compound.func_74779_i("lock1"));
        this.lock[2] = Item.func_111206_d((String)compound.func_74779_i("lock2"));
        this.lock[3] = Item.func_111206_d((String)compound.func_74779_i("lock3"));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return false;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.guiStackHandler;
            }
            return null;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getField(int id) {
        if (id == 4) {
            return this.state;
        }
        if (id == 3) {
            return this.timeLeft;
        }
        return super.getField(id);
    }

    @Override
    public void setField(int id, int value) {
        if (id == 4) {
            this.state = value;
        } else if (id == 3) {
            this.timeLeft = value;
        } else {
            super.setField(id, value);
        }
    }

    public void clearLock() {
        for (int i = 0; i < 4; ++i) {
            this.lock[i] = null;
        }
    }

    public ItemStack maskBlock() {
        return this.guiStackHandler.getStackInSlot(1);
    }

    public boolean hasFastRenderer() {
        return true;
    }
}

