/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.api.capability.genes;

import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.util.MobToGeneObject;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraftforge.fml.common.Optional;

public class MobToGeneRegistry {
    private static HashSet<MobToGeneObject> list = new HashSet();

    public static void init() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityVillager", EnumGenes.EMERALD_HEART));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySheep", EnumGenes.EAT_GRASS, EnumGenes.WOOLY));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityCow", EnumGenes.EAT_GRASS, EnumGenes.MILKY));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityHorse", EnumGenes.JUMP_BOOST));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityChicken", EnumGenes.NO_FALL_DAMAGE));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityBat", EnumGenes.FLY, EnumGenes.NIGHT_VISION));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityOcelot", EnumGenes.SPEED, EnumGenes.SCARE_CREEPERS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityPolarBear", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityRabbit", EnumGenes.JUMP_BOOST, EnumGenes.SPEED));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySquid", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityIronGolem", EnumGenes.MORE_HEARTS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityZombie", EnumGenes.RESISTANCE));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityCreeper", EnumGenes.EXPLOSIVE_EXIT));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySpider", EnumGenes.NIGHT_VISION));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityCaveSpider", EnumGenes.NIGHT_VISION, EnumGenes.POISON_PROOF));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntitySlime", EnumGenes.SLIMY));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityGuardian", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityEndermite", EnumGenes.SAVE_INVENTORY, EnumGenes.ITEM_MAGNET, EnumGenes.XP_MAGNET));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityEnderman", EnumGenes.TELEPORTER, EnumGenes.MORE_HEARTS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityShulker", EnumGenes.RESISTANCE));
        MobToGeneRegistry.registerMob(new MobToGeneObject("Wither Skeleton", EnumGenes.WITHER_HIT));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityBlaze", EnumGenes.SHOOT_FIREBALLS, EnumGenes.FIRE_PROOF));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityGhast", EnumGenes.FLY, EnumGenes.SHOOT_FIREBALLS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityPigZombie", EnumGenes.FIRE_PROOF));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityMagmaCube", EnumGenes.FIRE_PROOF));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityWither", EnumGenes.WITHER_PROOF, EnumGenes.FLY));
        MobToGeneRegistry.registerMob(new MobToGeneObject("Ender Dragon", EnumGenes.DRAGONS_BREATH, EnumGenes.ENDER_DRAGON_HEALTH));
        try {
            MobToGeneRegistry.registerArsMagica();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            MobToGeneRegistry.registerGrimoireOfGaia();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            MobToGeneRegistry.registerMoCreatures();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static void registerMob(MobToGeneObject obj) {
        list.add(obj);
    }

    public static String getGene(String entityCodeName) {
        String genename = "BasicGene";
        String g = "GeneticsReborn";
        int numb = ThreadLocalRandom.current().nextInt(1, 101);
        if (numb > 40) {
            return g + genename;
        }
        MobToGeneObject object = null;
        for (MobToGeneObject obj : list) {
            if (!obj.MobCodeName.equals(entityCodeName)) continue;
            object = obj;
            break;
        }
        if (object == null || object.getValidGenesNum() == 0) {
            return g + genename;
        }
        ArrayList<EnumGenes> genes = new ArrayList<EnumGenes>();
        genes.add(object.Gene1);
        if (object.Gene2 != null) {
            genes.add(object.Gene2);
        }
        if (object.Gene3 != null) {
            genes.add(object.Gene3);
        }
        if (genes.size() == 1) {
            genename = ((EnumGenes)((Object)genes.get(0))).toString();
        } else if (genes.size() == 2) {
            genename = ((EnumGenes)((Object)genes.get(ThreadLocalRandom.current().nextInt(2)))).toString();
        } else if (genes.size() == 3) {
            genename = ((EnumGenes)((Object)genes.get(ThreadLocalRandom.current().nextInt(3)))).toString();
        }
        String fullname = g + genename;
        if (!ModUtils.isGeneEnabled(fullname)) {
            fullname = g + "BasicGene";
        }
        return fullname;
    }

    @Optional.Method(modid="arsmagica2")
    public static void registerArsMagica() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityDryad", EnumGenes.PHOTOSYNTHESIS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityNatureGuardian", EnumGenes.PHOTOSYNTHESIS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityWaterGuardian", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityAirGuardian", EnumGenes.NO_FALL_DAMAGE));
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityFireGuardian", EnumGenes.FIRE_PROOF));
    }

    @Optional.Method(modid="grimoireofgaia")
    public static void registerGrimoireOfGaia() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("EntityGaiaDryad", EnumGenes.PHOTOSYNTHESIS));
    }

    @Optional.Method(modid="mocreatures")
    public static void registerMoCreatures() {
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityFly", EnumGenes.FLY));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityAnchovy", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityAngelFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityAngler", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBass", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityClownFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityCod", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityFishy", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityGoldFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityHippoTang", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityMantaRay", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityMediumFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityPiranha", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityRay", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntitySalmon", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityShark", EnumGenes.WATER_BREATHING, EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntitySmallFish", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityStringRay", EnumGenes.WATER_BREATHING));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityFireOgre", EnumGenes.FIRE_PROOF));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityOgre", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityWerewolf", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBear", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBlackBear", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBigCat", EnumGenes.SCARE_CREEPERS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityBunny", EnumGenes.JUMP_BOOST));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityKitty", EnumGenes.SCARE_CREEPERS));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityLion", EnumGenes.STRENGTH));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityScorpion", EnumGenes.POISON_PROOF));
        MobToGeneRegistry.registerMob(new MobToGeneObject("MoCEntityTurtle", EnumGenes.RESISTANCE));
    }
}

