/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.blocks.bloodpurifier;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.tile.GRTileEntityBasicEnergyReceiver;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class GRTileEntityBloodPurifier
extends GRTileEntityBasicEnergyReceiver
implements ITickable {
    public static int TICKS_NEEDED = GeneticsReborn.baseTickBloodPurifier;
    public static int baseRfPerTick = GeneticsReborn.baseRfPerTickBloodPurifier;
    private static final byte TICKS_COOKING_FIELD_ID = 0;
    private static final byte ENERGY_STORED_FIELD_ID = 1;
    private static final byte OVERCLOCKERS_FIELD_ID = 2;
    private static final byte NUMBER_OF_FIELDS = 3;

    public void func_73660_a() {
        int rfpertick = baseRfPerTick + this.overclockers * 85;
        if (this.canSmelt()) {
            if (this.energy > rfpertick) {
                this.energy -= rfpertick;
                ++this.ticksCooking;
                this.func_70296_d();
            }
            if (this.ticksCooking < 0) {
                this.ticksCooking = 0;
            }
            if (this.ticksCooking >= TICKS_NEEDED - this.overclockers * 39) {
                this.smeltItem();
                this.ticksCooking = 0;
            }
        } else {
            this.ticksCooking = 0;
        }
    }

    public static ItemStack getSmeltingResultForItem(ItemStack stack) {
        if (stack != null && (stack.func_77973_b() == GRItems.GlassSyringe || stack.func_77973_b() == GRItems.MetalSyringe) && stack.func_77978_p() != null && stack.func_77952_i() == 1) {
            ItemStack result = stack.func_77973_b() == GRItems.GlassSyringe ? new ItemStack(GRItems.GlassSyringe, 1, 1) : new ItemStack(GRItems.MetalSyringe, 1, 1);
            NBTTagCompound tag = stack.func_77978_p().func_74737_b();
            result.func_77982_d(tag);
            ModUtils.getTagCompound(result).func_74757_a("pure", true);
            return result;
        }
        return null;
    }

    private boolean canSmelt() {
        return this.smeltItem(false);
    }

    private void smeltItem() {
        this.smeltItem(true);
    }

    private boolean smeltItem(boolean performSmelt) {
        ItemStack result;
        IItemHandler inventory = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        IItemHandler inventoryoutput = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        if (inventory != null && inventory.getStackInSlot(0) != null && (result = GRTileEntityBloodPurifier.getSmeltingResultForItem(inventory.getStackInSlot(0))) != null) {
            ItemStack outputSlotStack = inventoryoutput.getStackInSlot(0);
            if (outputSlotStack == null) {
                if (inventoryoutput.insertItem(0, result, !performSmelt) == null) {
                    inventory.extractItem(0, 1, !performSmelt);
                    this.func_70296_d();
                    return true;
                }
            } else {
                if (inventoryoutput.insertItem(0, result, true) != null) {
                    return false;
                }
                inventoryoutput.insertItem(0, result, !performSmelt);
                inventory.extractItem(0, 1, !performSmelt);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public double percComplete() {
        return (double)this.ticksCooking / (double)(TICKS_NEEDED - this.overclockers * 39);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public int getField(int id) {
        if (id == 0) {
            return this.ticksCooking;
        }
        if (id == 1) {
            return this.getEnergyStored(null);
        }
        if (id == 2) {
            return this.overclockers;
        }
        System.err.println("Invalid field ID in GRTileEntity.getField:" + id);
        return 0;
    }

    public void setField(int id, int value) {
        if (id == 0) {
            this.ticksCooking = (short)value;
        } else if (id == 1) {
            this.energy = (short)value;
        } else if (id == 2) {
            this.overclockers = (short)value;
        } else {
            System.err.println("Invalid field ID in GRTileEntity.setField:" + id);
        }
    }

    public int getFieldCount() {
        return 3;
    }
}

