/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.blocks.coalgenerator;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class GRTileEntityCoalGenerator
extends TileEntity
implements IEnergyProvider,
ITickable {
    public static int maxExtract = GeneticsReborn.CoalGeneratorMaxExtract;
    public static int capacity = GeneticsReborn.maxEnergyStored;
    public int ticksleft;
    private boolean active;
    private int energy;
    public short overclockers;
    private ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            GRTileEntityCoalGenerator.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack == null || stack.field_77994_a == 0) {
                return null;
            }
            if (!ModUtils.isValidFuel(stack)) {
                return stack.func_77946_l();
            }
            this.validateSlotIndex(slot);
            ItemStack existing = this.stacks[slot];
            int limit = this.getStackLimit(slot, stack);
            if (existing != null) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.field_77994_a;
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.field_77994_a > limit;
            if (!simulate) {
                if (existing == null) {
                    this.stacks[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
                } else {
                    existing.field_77994_a = existing.field_77994_a + (reachedLimit ? limit : stack.field_77994_a);
                }
                this.onContentsChanged(slot);
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - limit)) : null;
        }
    };

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        IItemHandler inv = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ItemStack stack = inv.getStackInSlot(0);
        if (!this.active && stack != null && ModUtils.isValidFuel(stack)) {
            this.active = true;
            this.ticksleft = TileEntityFurnace.func_145952_a((ItemStack)stack) / 2;
            inv.extractItem(0, 1, false);
        }
        if (this.active && capacity - this.energy >= this.getRfPerTick()) {
            --this.ticksleft;
            this.energy += this.getRfPerTick();
            if (this.energy > capacity) {
                this.energy = capacity;
            }
            if (this.ticksleft < 1) {
                this.ticksleft = 0;
                this.active = false;
            }
        }
        BlockPos p = this.func_174877_v();
        if (this.energy > 0) {
            this.transferEnergy(p.func_177984_a(), EnumFacing.DOWN);
            this.transferEnergy(p.func_177977_b(), EnumFacing.UP);
            this.transferEnergy(p.func_177974_f(), EnumFacing.WEST);
            this.transferEnergy(p.func_177976_e(), EnumFacing.EAST);
            this.transferEnergy(p.func_177978_c(), EnumFacing.SOUTH);
            this.transferEnergy(p.func_177968_d(), EnumFacing.NORTH);
        }
    }

    public void transferEnergy(BlockPos target, EnumFacing targetFace) {
        int energyTransferred;
        int maxAvailable;
        IBlockState targetState = this.func_145831_w().func_180495_p(target);
        if (targetState instanceof IEnergyHandler) {
            maxAvailable = this.extractEnergy(null, maxExtract, true);
            energyTransferred = ((IEnergyHandler)targetState).receiveEnergy(targetFace, maxAvailable, false);
            this.extractEnergy(null, energyTransferred, false);
        }
        if (targetState instanceof IEnergyStorage) {
            maxAvailable = this.extractEnergy(null, maxExtract, true);
            energyTransferred = ((IEnergyStorage)targetState).receiveEnergy(maxAvailable, false);
            this.extractEnergy(null, energyTransferred, false);
        }
    }

    public int getRfPerTick() {
        return GeneticsReborn.CoalGeneratorBaseRF + GeneticsReborn.CoalGeneratorBaseRF * this.overclockers;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing facing) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing facing, int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(GRTileEntityCoalGenerator.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(EnumFacing facing) {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing facing) {
        return capacity;
    }

    public void addOverclocker(EntityPlayer player, int maxOverclockers) {
        if (this.overclockers < maxOverclockers) {
            this.overclockers = (short)(this.overclockers + 1);
            --player.func_184586_b((EnumHand)EnumHand.MAIN_HAND).field_77994_a;
            if (player.func_184586_b((EnumHand)EnumHand.MAIN_HAND).field_77994_a < 1) {
                player.func_184611_a(EnumHand.MAIN_HAND, null);
            }
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("Max Overclockers is " + maxOverclockers));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStackHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputitem", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74768_a("ticksleft", this.ticksleft);
        compound.func_74768_a("Energy", this.energy);
        compound.func_74777_a("overclockers", this.overclockers);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("inputitem")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("inputitem"));
        }
        this.ticksleft = compound.func_74762_e("ticksleft");
        this.energy = compound.func_74762_e("Energy");
        this.overclockers = compound.func_74765_d("overclockers");
        if (this.energy > capacity) {
            this.energy = capacity;
        }
    }
}

