/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.blocks.plasmidinjector;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.Genes;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.tile.GRTileEntityBasicEnergyReceiver;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class GRTileEntityPlasmidInjector
extends GRTileEntityBasicEnergyReceiver
implements ITickable {
    public static int TICKS_NEEDED = GeneticsReborn.baseTickPlasmidInjector;
    public static int baseRfPerTick = GeneticsReborn.baseRfPerTickPlasmidInjector;
    private static final byte TICKS_COOKING_FIELD_ID = 0;
    private static final byte ENERGY_STORED_FIELD_ID = 1;
    private static final byte OVERCLOCKERS_FIELD_ID = 2;
    private static final byte NUMBER_OF_FIELDS = 3;

    public void func_73660_a() {
        int rfpertick = baseRfPerTick + this.overclockers * 85;
        if (this.canSmelt()) {
            if (this.energy > rfpertick) {
                this.energy -= rfpertick;
                ++this.ticksCooking;
                this.func_70296_d();
            }
            if (this.ticksCooking < 0) {
                this.ticksCooking = 0;
            }
            if (this.ticksCooking >= TICKS_NEEDED - this.overclockers * 39) {
                this.smeltItem();
                this.ticksCooking = 0;
            }
        } else {
            this.ticksCooking = 0;
        }
    }

    private boolean canSmelt() {
        return this.smeltItem(false);
    }

    private void smeltItem() {
        this.smeltItem(true);
    }

    private boolean smeltItem(boolean performSmelt) {
        IItemHandler inventory = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        IItemHandler inventoryoutput = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        if (inventory != null && inventory.getStackInSlot(0) != null && inventoryoutput != null && inventoryoutput.getStackInSlot(0) != null) {
            ItemStack item = inventory.getStackInSlot(0);
            ItemStack result = inventoryoutput.getStackInSlot(0);
            if (result.func_77973_b() != GRItems.GlassSyringe && result.func_77973_b() != GRItems.MetalSyringe) {
                return false;
            }
            if (item.func_77978_p() != null) {
                NBTTagCompound itemtag = ModUtils.getTagCompound(item);
                if (result.func_77978_p() == null || result.func_77952_i() == 0 || !result.func_77978_p().func_74767_n("pure")) {
                    return false;
                }
                NBTTagCompound resulttag = ModUtils.getTagCompound(result);
                if (itemtag.func_74762_e("num") == itemtag.func_74762_e("numNeeded")) {
                    if (item.func_77973_b() == GRItems.AntiPlasmid) {
                        for (int i = 0; i < Genes.TotalNumberOfGenes; ++i) {
                            if (resulttag.func_74764_b(i + "anti")) {
                                if (!resulttag.func_74779_i(i + "anti").equals(itemtag.func_74779_i("gene"))) continue;
                                return false;
                            }
                            if (performSmelt) {
                                resulttag.func_74778_a(i + "anti", itemtag.func_74779_i("gene"));
                                resulttag.func_74757_a("pure", false);
                                inventory.extractItem(0, item.field_77994_a, false);
                                this.func_70296_d();
                            }
                            return true;
                        }
                    } else if (item.func_77973_b() == GRItems.Plasmid) {
                        for (int i = 0; i < Genes.TotalNumberOfGenes; ++i) {
                            if (resulttag.func_74764_b(Integer.toString(i))) {
                                if (!resulttag.func_74779_i(Integer.toString(i)).equals(itemtag.func_74779_i("gene"))) continue;
                                return false;
                            }
                            if (performSmelt) {
                                resulttag.func_74778_a(Integer.toString(i), itemtag.func_74779_i("gene"));
                                resulttag.func_74757_a("pure", false);
                                inventory.extractItem(0, item.field_77994_a, false);
                                this.func_70296_d();
                            }
                            return true;
                        }
                    }
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    public double percComplete() {
        return (double)this.ticksCooking / (double)(TICKS_NEEDED - this.overclockers * 39);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public int getField(int id) {
        if (id == 0) {
            return this.ticksCooking;
        }
        if (id == 1) {
            return this.getEnergyStored(null);
        }
        if (id == 2) {
            return this.overclockers;
        }
        System.err.println("Invalid field ID in GRTileEntity.getField:" + id);
        return 0;
    }

    public void setField(int id, int value) {
        if (id == 0) {
            this.ticksCooking = (short)value;
        } else if (id == 1) {
            this.energy = (short)value;
        } else if (id == 2) {
            this.overclockers = (short)value;
        } else {
            System.err.println("Invalid field ID in GRTileEntity.setField:" + id);
        }
    }

    public int getFieldCount() {
        return 3;
    }
}

