/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.blocks.cloningmachine;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.tile.GRTileEntityBasicEnergyReceiver;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class GRTileEntityCloningMachine
extends GRTileEntityBasicEnergyReceiver
implements ITickable {
    public static int TICKS_NEEDED = GeneticsReborn.baseTickCloningMachine;
    public static int baseRfPerTick = GeneticsReborn.baseRfPerTickCloningMachine;
    private static final byte TICKS_COOKING_FIELD_ID = 0;
    private static final byte ENERGY_STORED_FIELD_ID = 1;
    private static final byte OVERCLOCKERS_FIELD_ID = 2;
    private static final byte NUMBER_OF_FIELDS = 3;

    public void func_73660_a() {
        int rfpertick = baseRfPerTick + this.overclockers * 1300;
        if (this.canSmelt()) {
            if (this.getEnergyStored(null) > rfpertick) {
                this.energy -= rfpertick;
                ++this.ticksCooking;
                if (this.energy < 0) {
                    this.energy = 0;
                }
                this.func_70296_d();
            }
            if (this.ticksCooking < 0) {
                this.ticksCooking = 0;
            }
            if (this.ticksCooking >= TICKS_NEEDED - this.overclockers * 39) {
                this.smeltItem();
                this.ticksCooking = 0;
            }
        } else {
            this.ticksCooking = 0;
        }
    }

    public static ItemStack getSmeltingResultForItem(ItemStack stack) {
        if (stack.func_77973_b() == GRItems.OrganicMatter && stack.func_77978_p() != null) {
            if (!ModUtils.getTagCompound(stack).func_74764_b("mobTag")) {
                return ItemStack.field_190927_a;
            }
            for (String entityClass : GeneticsReborn.CloningBlacklist) {
                if (!entityClass.equals(ModUtils.getTagCompound(stack).func_74779_i("entityCodeName"))) continue;
                return ItemStack.field_190927_a;
            }
            ItemStack result = new ItemStack(GRItems.OrganicMatter);
            ModUtils.getTagCompound(result).func_74778_a("entityName", ModUtils.getTagCompound(stack).func_74779_i("entityName"));
            ModUtils.getTagCompound(result).func_74778_a("entityCodeName", ModUtils.getTagCompound(stack).func_74779_i("entityCodeName"));
            return result;
        }
        return ItemStack.field_190927_a;
    }

    private boolean canSmelt() {
        return this.smeltItem(false);
    }

    private void smeltItem() {
        this.smeltItem(true);
    }

    private boolean smeltItem(boolean performSmelt) {
        ItemStack result;
        IItemHandler inventory = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        IItemHandler inventoryoutput = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        if (inventory != null && !inventory.getStackInSlot(0).func_190926_b() && !(result = GRTileEntityCloningMachine.getSmeltingResultForItem(inventory.getStackInSlot(0))).func_190926_b()) {
            ItemStack inputSlotStack = inventory.getStackInSlot(0);
            ItemStack outputSlotStack = inventoryoutput.getStackInSlot(0);
            if (outputSlotStack.func_190926_b()) {
                if (inventoryoutput.insertItem(0, result, !performSmelt).func_190926_b()) {
                    inventory.extractItem(0, 1, !performSmelt);
                    if (performSmelt) {
                        this.spawnEntity(ModUtils.getTagCompound(inputSlotStack));
                    }
                    this.func_70296_d();
                    return true;
                }
            } else {
                if (!inventoryoutput.insertItem(0, result, true).func_190926_b()) {
                    return false;
                }
                inventoryoutput.insertItem(0, result, !performSmelt);
                inventory.extractItem(0, 1, !performSmelt);
                this.func_70296_d();
                if (performSmelt) {
                    this.spawnEntity(ModUtils.getTagCompound(inputSlotStack));
                }
                return true;
            }
        }
        return false;
    }

    public void spawnEntity(NBTTagCompound tag) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        NBTBase mobCompound = tag.func_74781_a("mobTag");
        String type = tag.func_74779_i("type");
        EntityLivingBase entityLivingBase = this.createEntity(this.func_145831_w(), type);
        if (entityLivingBase != null) {
            entityLivingBase.func_70037_a((NBTTagCompound)mobCompound);
            entityLivingBase.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 2.0, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
            this.func_145831_w().func_72838_d((Entity)entityLivingBase);
        }
    }

    public EntityLivingBase createEntity(World world, String type) {
        EntityLivingBase entityLivingBase;
        try {
            entityLivingBase = (EntityLivingBase)Class.forName(type).getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            entityLivingBase = null;
        }
        return entityLivingBase;
    }

    public double percComplete() {
        return (double)this.ticksCooking / (double)(TICKS_NEEDED - this.overclockers * 39);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public int getField(int id) {
        if (id == 0) {
            return this.ticksCooking;
        }
        if (id == 1) {
            return this.getEnergyStored(null);
        }
        if (id == 2) {
            return this.overclockers;
        }
        System.err.println("Invalid field ID in GRTileEntity.getField:" + id);
        return 0;
    }

    public void setField(int id, int value) {
        if (id == 0) {
            this.ticksCooking = (short)value;
        } else if (id == 1) {
            this.energy = (short)value;
        } else if (id == 2) {
            this.overclockers = (short)value;
        } else {
            System.err.println("Invalid field ID in GRTileEntity.setField:" + id);
        }
    }

    public int getFieldCount() {
        return 3;
    }
}

