/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.event;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.blocks.GRBlocks;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerTickEvent {
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        IGenes genes = ModUtils.getIGenes((EntityLivingBase)event.player);
        World world = event.player.func_130014_f_();
        if (player == null || genes == null || world.field_72995_K) {
            return;
        }
        PlayerTickEvent.tryItemMagnet(player, world, genes);
        PlayerTickEvent.tryXPMagnet(player, world, genes);
        PlayerTickEvent.tryPhotosynthesis(player, world, genes);
    }

    public static void tryItemMagnet(EntityPlayer player, World world, IGenes genes) {
        if (GeneticsReborn.enableItemMagnet && genes.hasGene(EnumGenes.ITEM_MAGNET) && !player.field_71071_by.func_70431_c(new ItemStack(GRItems.AntiField)) && !player.func_70093_af()) {
            for (EntityItem entityItem : ModUtils.getEntitiesInRange(EntityItem.class, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, 6.5)) {
                if (!entityItem.func_184216_O().contains("geneticsrebornLOL") && PlayerTickEvent.shouldPickupItem(world, entityItem.func_180425_c())) {
                    EntityItemPickupEvent pickupEvent = new EntityItemPickupEvent(player, entityItem);
                    MinecraftForge.EVENT_BUS.post((Event)pickupEvent);
                    ItemStack itemStackToGet = entityItem.func_92059_d();
                    int stackSize = itemStackToGet.func_190916_E();
                    if (pickupEvent.getResult() != Event.Result.ALLOW && stackSize > 0 && player.field_71071_by.func_70441_a(itemStackToGet)) continue;
                    player.func_71001_a((Entity)entityItem, stackSize);
                    world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 0.15f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    continue;
                }
                if (entityItem.func_184216_O().contains("geneticsrebornLOL")) continue;
                entityItem.func_184211_a("geneticsrebornLOL");
            }
        }
    }

    public static void tryXPMagnet(EntityPlayer player, World world, IGenes genes) {
        if (GeneticsReborn.enableXPMagnet && genes.hasGene(EnumGenes.XP_MAGNET) && !player.field_71071_by.func_70431_c(new ItemStack(GRItems.AntiField)) && !player.func_70093_af()) {
            for (EntityXPOrb entityXPOrb : ModUtils.getEntitiesInRange(EntityXPOrb.class, world, player.field_70165_t, player.field_70163_u, player.field_70161_v, 6.5)) {
                if (entityXPOrb.field_70128_L || entityXPOrb.func_82150_aj()) continue;
                player.field_71090_bL = 0;
                entityXPOrb.field_70532_c = 0;
                entityXPOrb.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                PlayerPickupXpEvent xpEvent = new PlayerPickupXpEvent(player, entityXPOrb);
                MinecraftForge.EVENT_BUS.post((Event)xpEvent);
                if (xpEvent.getResult() != Event.Result.ALLOW) continue;
                entityXPOrb.func_70100_b_(player);
            }
        }
    }

    public static void tryPhotosynthesis(EntityPlayer player, World world, IGenes genes) {
        double rand;
        if (GeneticsReborn.enablePhotosynthesis && genes.hasGene(EnumGenes.PHOTOSYNTHESIS) && world.func_72935_r() && world.func_175645_m(player.func_180425_c()).func_177956_o() < player.func_180425_c().func_177956_o() + 1 && (rand = Math.random()) < 0.01) {
            player.func_71024_bL().func_75122_a(1, 0.5f);
        }
    }

    public static boolean shouldPickupItem(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int i = -5; i <= 5; ++i) {
            BlockPos newpos = new BlockPos(x, y + i, z);
            if (world.func_180495_p(newpos).func_177230_c() != GRBlocks.AntiFieldBlock) continue;
            return false;
        }
        return true;
    }
}

