/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.util;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.api.capability.genes.GeneCapabilityProvider;
import com.theundertaker11.geneticsreborn.api.capability.genes.IGenes;
import com.theundertaker11.geneticsreborn.api.capability.maxhealth.IMaxHealth;
import com.theundertaker11.geneticsreborn.api.capability.maxhealth.MaxHealthCapabilityProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class ModUtils {
    public static final int moveSpeed = 1;
    public static final int moveSlowness = 2;
    public static final int digSpeed = 3;
    public static final int miningSlowDown = 4;
    public static final int strength = 5;
    public static final int jumpBoost = 8;
    public static final int nausea = 9;
    public static final int regeneration = 10;
    public static final int resistance = 11;
    public static final int fireResistance = 12;
    public static final int waterBreathing = 13;
    public static final int invisibility = 14;
    public static final int blindness = 15;
    public static final int nightVision = 16;
    public static final int hunger = 17;
    public static final int weakness = 18;
    public static final int poison = 19;
    public static final int wither = 20;
    public static final int ATTRIBUTE_MODIFIER_OPERATION_ADD = 0;

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    public static boolean isValidFuel(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }

    public static void TeleportPlayer(EntityPlayer player, double x, double y, double z, int dimension) {
        if (player.field_71093_bK == dimension) {
            player.func_70634_a(x, y, z);
        } else {
            player.func_184204_a(dimension);
            player.func_70634_a(x, y, z);
        }
    }

    @Nullable
    public static IGenes getIGenes(EntityLivingBase entityliving) {
        return (IGenes)entityliving.getCapability(GeneCapabilityProvider.GENES_CAPABILITY, null);
    }

    @Nullable
    public static IMaxHealth getIMaxHealth(EntityLivingBase entity) {
        return (IMaxHealth)entity.getCapability(MaxHealthCapabilityProvider.MAX_HEALTH_CAPABILITY, null);
    }

    public static String getGeneNameForShow(String rawname) {
        String genename = "This is an error. Report to Genetics Reborn Github.";
        if (rawname.equals("GeneticsRebornBasicGene")) {
            genename = "Basic Gene";
        }
        if (rawname.equals("GeneticsRebornDRAGONS_BREATH")) {
            genename = "Dragon's Breath";
        }
        if (rawname.equals("GeneticsRebornEAT_GRASS")) {
            genename = "Eat Grass";
        }
        if (rawname.equals("GeneticsRebornEMERALD_HEART")) {
            genename = "Emerald Heart";
        }
        if (rawname.equals("GeneticsRebornENDER_DRAGON_HEALTH")) {
            genename = "Ender Dragon Health";
        }
        if (rawname.equals("GeneticsRebornFIRE_PROOF")) {
            genename = "Fire Proof";
        }
        if (rawname.equals("GeneticsRebornFLY")) {
            genename = "Fly";
        }
        if (rawname.equals("GeneticsRebornJUMP_BOOST")) {
            genename = "Jump Boost";
        }
        if (rawname.equals("GeneticsRebornMILKY")) {
            genename = "Milky";
        }
        if (rawname.equals("GeneticsRebornMORE_HEARTS")) {
            genename = "More Hearts";
        }
        if (rawname.equals("GeneticsRebornNIGHT_VISION")) {
            genename = "Night Vision";
        }
        if (rawname.equals("GeneticsRebornNO_FALL_DAMAGE")) {
            genename = "No Fall Damage";
        }
        if (rawname.equals("GeneticsRebornPOISON_PROOF")) {
            genename = "Poison Immunity";
        }
        if (rawname.equals("GeneticsRebornRESISTANCE")) {
            genename = "Resistance";
        }
        if (rawname.equals("GeneticsRebornSAVE_INVENTORY")) {
            genename = "Keep Inventory";
        }
        if (rawname.equals("GeneticsRebornSCARE_CREEPERS")) {
            genename = "Scare Creepers";
        }
        if (rawname.equals("GeneticsRebornSHOOT_FIREBALLS")) {
            genename = "Shoot Fireballs";
        }
        if (rawname.equals("GeneticsRebornSLIMY")) {
            genename = "Slimy";
        }
        if (rawname.equals("GeneticsRebornSPEED")) {
            genename = "Speed";
        }
        if (rawname.equals("GeneticsRebornTELEPORTER")) {
            genename = "Teleporter";
        }
        if (rawname.equals("GeneticsRebornWATER_BREATHING")) {
            genename = "Water Breathing";
        }
        if (rawname.equals("GeneticsRebornWOOLY")) {
            genename = "Wooly";
        }
        if (rawname.equals("GeneticsRebornWITHER_HIT")) {
            genename = "Wither Hit";
        }
        if (rawname.equals("GeneticsRebornWITHER_PROOF")) {
            genename = "Wither Proof";
        }
        if (rawname.equals("GeneticsRebornXP_MAGNET")) {
            genename = "XP Attraction Field";
        }
        if (rawname.equals("GeneticsRebornITEM_MAGNET")) {
            genename = "Item Attraction Field";
        }
        if (rawname.equals("GeneticsRebornEXPLOSIVE_EXIT")) {
            genename = "Explosive Exit";
        }
        if (rawname.equals("GeneticsRebornSTRENGTH")) {
            genename = "Strength";
        }
        if (rawname.equals("GeneticsRebornPHOTOSYNTHESIS")) {
            genename = "Photosynthesis";
        }
        return genename;
    }

    public static boolean isGeneEnabled(String rawname) {
        if (rawname.equals("GeneticsRebornBasicGene")) {
            return true;
        }
        if (rawname.equals("GeneticsRebornDRAGONS_BREATH")) {
            return GeneticsReborn.enableDragonsBreath;
        }
        if (rawname.equals("GeneticsRebornEAT_GRASS")) {
            return GeneticsReborn.enableEatGrass;
        }
        if (rawname.equals("GeneticsRebornEMERALD_HEART")) {
            return GeneticsReborn.enableEmeraldHeart;
        }
        if (rawname.equals("GeneticsRebornENDER_DRAGON_HEALTH")) {
            return GeneticsReborn.enableEnderDragonHealth;
        }
        if (rawname.equals("GeneticsRebornFIRE_PROOF")) {
            return GeneticsReborn.enableFireProof;
        }
        if (rawname.equals("GeneticsRebornFLY")) {
            return GeneticsReborn.enableFlight;
        }
        if (rawname.equals("GeneticsRebornJUMP_BOOST")) {
            return GeneticsReborn.enableJumpBoost;
        }
        if (rawname.equals("GeneticsRebornMILKY")) {
            return GeneticsReborn.enableMilky;
        }
        if (rawname.equals("GeneticsRebornMORE_HEARTS")) {
            return GeneticsReborn.enableMoreHearts;
        }
        if (rawname.equals("GeneticsRebornNIGHT_VISION")) {
            return GeneticsReborn.enableNightVision;
        }
        if (rawname.equals("GeneticsRebornNO_FALL_DAMAGE")) {
            return GeneticsReborn.enableNoFallDamage;
        }
        if (rawname.equals("GeneticsRebornPOISON_PROOF")) {
            return GeneticsReborn.enablePoisonProof;
        }
        if (rawname.equals("GeneticsRebornRESISTANCE")) {
            return GeneticsReborn.enableResistance;
        }
        if (rawname.equals("GeneticsRebornSAVE_INVENTORY")) {
            return GeneticsReborn.enableSaveInventory;
        }
        if (rawname.equals("GeneticsRebornSCARE_CREEPERS")) {
            return GeneticsReborn.enableScareCreepers;
        }
        if (rawname.equals("GeneticsRebornSHOOT_FIREBALLS")) {
            return GeneticsReborn.enableShootFireballs;
        }
        if (rawname.equals("GeneticsRebornSLIMY")) {
            return GeneticsReborn.enableSlimy;
        }
        if (rawname.equals("GeneticsRebornSPEED")) {
            return GeneticsReborn.enableSpeed;
        }
        if (rawname.equals("GeneticsRebornTELEPORTER")) {
            return GeneticsReborn.enableTeleporter;
        }
        if (rawname.equals("GeneticsRebornWATER_BREATHING")) {
            return GeneticsReborn.enableTeleporter;
        }
        if (rawname.equals("GeneticsRebornWOOLY")) {
            return GeneticsReborn.enableWooly;
        }
        if (rawname.equals("GeneticsRebornWITHER_HIT")) {
            return GeneticsReborn.enableWitherHit;
        }
        if (rawname.equals("GeneticsRebornWITHER_PROOF")) {
            return GeneticsReborn.enableWitherProof;
        }
        if (rawname.equals("GeneticsRebornXP_MAGNET")) {
            return GeneticsReborn.enableXPMagnet;
        }
        if (rawname.equals("GeneticsRebornITEM_MAGNET")) {
            return GeneticsReborn.enableItemMagnet;
        }
        if (rawname.equals("GeneticsRebornEXPLOSIVE_EXIT")) {
            return GeneticsReborn.enableExplosiveExit;
        }
        if (rawname.equals("GeneticsRebornSTRENGTH")) {
            return GeneticsReborn.enableStrength;
        }
        if (rawname.equals("GeneticsRebornPHOTOSYNTHESIS")) {
            return GeneticsReborn.enablePhotosynthesis;
        }
        return false;
    }

    public static List<Entity> getEntitiesInRange(Class<? extends Entity> entityType, World world, double x, double y, double z, double radius) {
        return ModUtils.getEntitesInTange(entityType, world, x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
    }

    public static List<Entity> getEntitesInTange(Class<? extends Entity> entityType, World world, double x, double y, double z, double x2, double y2, double z2) {
        return world.func_72872_a(entityType, new AxisAlignedBB(x, y, z, x2, y2, z2));
    }
}

