/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep;

import com.legacy.goodnightsleep.blocks.BlocksGNS;
import com.legacy.goodnightsleep.items.tools.ItemGNSHoe;
import com.legacy.goodnightsleep.player.PlayerGNS;
import com.legacy.goodnightsleep.player.capability.GNSProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GNSEventHandler {
    private static final ResourceLocation PLAYER_LOCATION = new ResourceLocation("goodnightsleep", "gns_player");

    @SubscribeEvent
    public void PlayerConstructingEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getObject();
            GNSProvider provider = new GNSProvider(new PlayerGNS(player));
            if (PlayerGNS.get(player) == null) {
                event.addCapability(PLAYER_LOCATION, (ICapabilityProvider)provider);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        PlayerGNS original = PlayerGNS.get(event.getOriginal());
        PlayerGNS clone = PlayerGNS.get(event.getEntityPlayer());
        NBTTagCompound compound = new NBTTagCompound();
        if (original != null && clone != null) {
            original.writeEntityToNBT(compound);
            clone.readEntityFromNBT(compound);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            PlayerGNS.get((EntityPlayer)event.getEntityLiving()).onUpdate();
        }
    }

    @SubscribeEvent
    public void haveDream(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == BlocksGNS.luxurious_bed && event.getEntityLiving() instanceof EntityPlayer) {
            if (event.getEntityLiving().field_71093_bK == 0) {
                PlayerGNS.get((EntityPlayer)((EntityPlayer)event.getEntityLiving())).lastBedPos = event.getEntityLiving().func_180425_c();
            }
            PlayerGNS.get((EntityPlayer)event.getEntityLiving()).teleportPlayer(true);
        }
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == BlocksGNS.wretched_bed && event.getEntityLiving() instanceof EntityPlayer) {
            if (event.getEntityLiving().field_71093_bK == 0) {
                PlayerGNS.get((EntityPlayer)((EntityPlayer)event.getEntityLiving())).lastBedPos = event.getEntityLiving().func_180425_c();
            }
            PlayerGNS.get((EntityPlayer)event.getEntityLiving()).teleportPlayerNightmare(true);
        }
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == BlocksGNS.strange_bed && event.getEntityLiving() instanceof EntityPlayer) {
            if (event.getEntityLiving().field_71093_bK == 0) {
                PlayerGNS.get((EntityPlayer)((EntityPlayer)event.getEntityLiving())).lastBedPos = event.getEntityLiving().func_180425_c();
            }
            if (event.getWorld().field_73012_v.nextBoolean()) {
                PlayerGNS.get((EntityPlayer)event.getEntityLiving()).teleportPlayer(true);
            } else {
                PlayerGNS.get((EntityPlayer)event.getEntityLiving()).teleportPlayerNightmare(true);
            }
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if ((stack.func_77973_b() instanceof ItemHoe || stack.func_77973_b() instanceof ItemGNSHoe) && world.func_175623_d(pos.func_177984_a()) && ((block = state.func_177230_c()) == BlocksGNS.dream_grass || block == BlocksGNS.dream_dirt)) {
            this.hoeDirt(stack, player, world, pos, BlocksGNS.dream_farmland.func_176223_P(), event);
        }
    }

    protected void hoeDirt(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state, PlayerInteractEvent.RightClickBlock event) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        player.func_184609_a(event.getHand());
    }

    protected void plantSeed(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
    }
}

