/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.blocks;

import com.legacy.goodnightsleep.blocks.BlocksGNS;
import com.legacy.goodnightsleep.entities.tile.TileEntityLuxuriousBed;
import com.legacy.goodnightsleep.entities.tile.TileEntityStrangeBed;
import com.legacy.goodnightsleep.entities.tile.TileEntityWretchedBed;
import com.legacy.goodnightsleep.items.ItemsGNS;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGNSBed
extends BlockHorizontal
implements ITileEntityProvider {
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    protected static final AxisAlignedBB BED_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);

    public BlockGNSBed() {
        super(Material.field_151580_n);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)));
        this.field_149758_A = true;
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149649_H();
        this.func_149711_c(0.2f);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            // empty if block
        }
        return MapColor.field_151659_e;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.5f);
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        if (entityIn.func_70093_af()) {
            super.func_176216_a(worldIn, entityIn);
        } else if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = -entityIn.field_70181_x * (double)0.66f;
            if (!(entityIn instanceof EntityLivingBase)) {
                entityIn.field_70181_x *= 0.8;
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175698_g(pos);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(PART) == EnumPartType.FOOT ? Items.field_190931_a : Items.field_151104_aV;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BED_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            if (this == BlocksGNS.luxurious_bed) {
                BlockGNSBed.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ItemsGNS.luxurious_bed_item, 1));
            } else if (this == BlocksGNS.strange_bed) {
                BlockGNSBed.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ItemsGNS.strange_bed_item, 1));
            } else {
                BlockGNSBed.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ItemsGNS.wretched_bed_item, 1));
            }
        }
    }

    public EnumPushReaction getMobilityFlag(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        BlockPos blockpos = pos;
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D));
        }
        EnumDyeColor enumdyecolor = (tileentity = worldIn.func_175625_s(blockpos)) instanceof TileEntityBed ? ((TileEntityBed)tileentity).func_193048_a() : EnumDyeColor.RED;
        return new ItemStack(Items.field_151104_aV, 1, enumdyecolor.func_176765_a());
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos;
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(PART) == EnumPartType.FOOT && worldIn.func_180495_p(blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D))).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (state.func_177229_b(PART) == EnumPartType.HEAD && te instanceof TileEntityBed) {
            TileEntityBed tileentitybed = (TileEntityBed)te;
            ItemStack itemstack = tileentitybed.func_193049_f();
            BlockGNSBed.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null, stack);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.HEAD)).func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing) : this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            i |= 8;
        }
        return i;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, PART});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this == BlocksGNS.luxurious_bed) {
            return new TileEntityLuxuriousBed();
        }
        if (this == BlocksGNS.strange_bed) {
            return new TileEntityStrangeBed();
        }
        return new TileEntityWretchedBed();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isHeadPiece(int metadata) {
        return (metadata & 8) != 0;
    }

    public static enum EnumPartType implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

