/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.blocks.construction;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGNSSlab
extends Block {
    public static final PropertyEnum<EnumBlockHalf> TYPE = PropertyEnum.func_177709_a((String)"half", EnumBlockHalf.class);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public BlockGNSSlab(Material materialIn) {
        super(materialIn);
        this.func_149713_g(255);
        this.func_180632_j(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumBlockHalf.BOTTOM)));
        this.func_149672_a(materialIn == Material.field_151575_d ? SoundType.field_185848_a : SoundType.field_185851_d);
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isDouble(state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, 0);
        drops.add((Object)new ItemStack((Block)this, this.isDouble(state) ? 1 : 0));
    }

    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing enumFacing) {
        if (this.isDouble(state)) {
            return BlockFaceShape.SOLID;
        }
        if (enumFacing == EnumFacing.UP && state.func_177229_b(TYPE) == EnumBlockHalf.TOP) {
            return BlockFaceShape.SOLID;
        }
        return enumFacing == EnumFacing.DOWN && state.func_177229_b(TYPE) == EnumBlockHalf.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return this.isDouble(state) || state.func_177229_b(TYPE) == EnumBlockHalf.TOP;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isDouble(state)) {
            return true;
        }
        EnumBlockHalf side = (EnumBlockHalf)((Object)state.func_177229_b(TYPE));
        return side == EnumBlockHalf.TOP && face == EnumFacing.UP || side == EnumBlockHalf.BOTTOM && face == EnumFacing.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        if (this.isDouble(state)) {
            return super.func_176225_a(state, access, pos, side);
        }
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && !super.func_176225_a(state, access, pos, side)) {
            return false;
        }
        return super.func_176225_a(state, access, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    protected static boolean isHalfSlab(IBlockState state) {
        return !((EnumBlockHalf)((Object)state.func_177229_b(TYPE))).equals((Object)EnumBlockHalf.FULL);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isDouble(state)) {
            return field_185505_j;
        }
        return state.func_177229_b(TYPE) == EnumBlockHalf.TOP ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumBlockHalf.BOTTOM)) : iblockstate.func_177226_a(TYPE, (Comparable)((Object)EnumBlockHalf.TOP));
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            case 0: {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumBlockHalf.BOTTOM));
            }
            case 1: {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumBlockHalf.TOP));
            }
            case 2: {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumBlockHalf.FULL));
            }
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumBlockHalf)((Object)state.func_177229_b(TYPE))) {
            case TOP: {
                return 0;
            }
            case BOTTOM: {
                return 1;
            }
            case FULL: {
                return 2;
            }
        }
        return 0;
    }

    public Comparable<?> getTypeForItem(ItemStack stack) {
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    private boolean isDouble(IBlockState state) {
        return ((EnumBlockHalf)((Object)state.func_177229_b(TYPE))).equals((Object)EnumBlockHalf.FULL);
    }

    public static enum EnumBlockHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom"),
        FULL("full");

        private final String name;

        private EnumBlockHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static int getAmount(IBlockState state) {
            return state.func_177229_b(TYPE) == FULL ? 2 : 1;
        }
    }
}

