/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.blocks.natural;

import com.legacy.goodnightsleep.blocks.BlocksGNS;
import com.legacy.goodnightsleep.registry.GNSCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGNSLog
extends BlockLog {
    public static PropertyEnum<BlockLog.EnumAxis> PROPERTY_LOG_AXIS = PropertyEnum.func_177709_a((String)"axis", BlockLog.EnumAxis.class);

    public BlockGNSLog() {
        if (this != BlocksGNS.dead_log && this != BlocksGNS.blood_log) {
            Blocks.field_150480_ab.func_180686_a((Block)this, 5, 5);
        } else {
            Blocks.field_150480_ab.func_180686_a((Block)this, 0, 0);
        }
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(GNSCreativeTabs.blocks);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(PROPERTY_LOG_AXIS, (Comparable)BlockLog.EnumAxis.Y));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((BlockLog.EnumAxis)state.func_177229_b(PROPERTY_LOG_AXIS)) {
                    case X: {
                        return state.func_177226_a(PROPERTY_LOG_AXIS, (Comparable)BlockLog.EnumAxis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(PROPERTY_LOG_AXIS, (Comparable)BlockLog.EnumAxis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int size = 4;
        int chunkSize = size + 1;
        if (world.func_175707_a(pos.func_177982_a(-chunkSize, -chunkSize, -chunkSize), pos.func_177982_a(chunkSize, chunkSize, chunkSize))) {
            for (BlockPos neighborPos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-size, -size, -size), (BlockPos)pos.func_177982_a(size, size, size))) {
                IBlockState neighborState = world.func_180495_p(neighborPos);
                if (!neighborState.func_177230_c().isLeaves(neighborState, (IBlockAccess)world, neighborPos)) continue;
                neighborState.func_177230_c().beginLeavesDecay(neighborState, world, neighborPos);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.NONE;
        switch (meta & 7) {
            case 1: {
                axis = BlockLog.EnumAxis.Y;
                break;
            }
            case 2: {
                axis = BlockLog.EnumAxis.X;
                break;
            }
            case 3: {
                axis = BlockLog.EnumAxis.Z;
            }
        }
        return this.func_176223_P().func_177226_a(PROPERTY_LOG_AXIS, (Comparable)axis);
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        switch ((BlockLog.EnumAxis)state.func_177229_b(PROPERTY_LOG_AXIS)) {
            case Y: {
                meta |= 1;
                break;
            }
            case X: {
                meta |= 2;
                break;
            }
            case Z: {
                meta |= 3;
                break;
            }
        }
        return meta;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_LOG_AXIS});
    }
}

