/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.client.renders;

import com.legacy.goodnightsleep.client.renders.blocks.TileEntityLuxuriousBedRenderer;
import com.legacy.goodnightsleep.client.renders.blocks.TileEntityStangeBedRenderer;
import com.legacy.goodnightsleep.client.renders.blocks.TileEntityWretchedBedRenderer;
import com.legacy.goodnightsleep.client.renders.entities.RenderBabyCreeper;
import com.legacy.goodnightsleep.client.renders.entities.RenderGummyBear;
import com.legacy.goodnightsleep.client.renders.entities.RenderHerobrine;
import com.legacy.goodnightsleep.client.renders.entities.RenderTormenter;
import com.legacy.goodnightsleep.client.renders.entities.RenderUnicorn;
import com.legacy.goodnightsleep.entities.dream.EntityBabyCreeper;
import com.legacy.goodnightsleep.entities.dream.EntityGummyBear;
import com.legacy.goodnightsleep.entities.dream.EntityUnicorn;
import com.legacy.goodnightsleep.entities.nightmare.EntityHerobrine;
import com.legacy.goodnightsleep.entities.nightmare.EntityTormenter;
import com.legacy.goodnightsleep.entities.tile.TileEntityLuxuriousBed;
import com.legacy.goodnightsleep.entities.tile.TileEntityStrangeBed;
import com.legacy.goodnightsleep.entities.tile.TileEntityWretchedBed;
import com.legacy.goodnightsleep.items.ItemsGNS;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class GNSEntityRenderingRegistry {
    public static void initialize() {
        GNSEntityRenderingRegistry.register(EntityTormenter.class, RenderTormenter.class);
        GNSEntityRenderingRegistry.register(EntityBabyCreeper.class, RenderBabyCreeper.class);
        GNSEntityRenderingRegistry.register(EntityHerobrine.class, RenderHerobrine.class);
        GNSEntityRenderingRegistry.register(EntityGummyBear.class, RenderGummyBear.class);
        GNSEntityRenderingRegistry.register(EntityUnicorn.class, RenderUnicorn.class);
    }

    public static void registerTileEntities() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLuxuriousBed.class, (TileEntitySpecialRenderer)new TileEntityLuxuriousBedRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWretchedBed.class, (TileEntitySpecialRenderer)new TileEntityWretchedBedRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStrangeBed.class, (TileEntitySpecialRenderer)new TileEntityStangeBedRenderer());
        ForgeHooksClient.registerTESRItemStack((Item)ItemsGNS.luxurious_bed_item, (int)0, TileEntityLuxuriousBed.class);
        ForgeHooksClient.registerTESRItemStack((Item)ItemsGNS.wretched_bed_item, (int)0, TileEntityWretchedBed.class);
        ForgeHooksClient.registerTESRItemStack((Item)ItemsGNS.strange_bed_item, (int)0, TileEntityStrangeBed.class);
    }

    private static <T extends Entity> void register(Class<T> clazz, final Class<? extends Render<T>> render) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, (IRenderFactory)new IRenderFactory<T>(){

            public Render<T> createRenderFor(RenderManager manager) {
                try {
                    return (Render)render.getConstructor(RenderManager.class).newInstance(manager);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }
}

