/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep;

import com.google.common.collect.ImmutableMap;
import com.legacy.goodnightsleep.blocks.GNSBlocks;
import com.legacy.goodnightsleep.world.GNSDimensions;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GNSEvents {
    public static final Map<Block, Block> BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().put((Object)GNSBlocks.dream_log, (Object)GNSBlocks.stripped_dream_log).put((Object)GNSBlocks.dream_wood, (Object)GNSBlocks.stripped_dream_wood).put((Object)GNSBlocks.white_log, (Object)GNSBlocks.stripped_white_log).put((Object)GNSBlocks.white_wood, (Object)GNSBlocks.stripped_white_wood).put((Object)GNSBlocks.dead_log, (Object)GNSBlocks.stripped_dead_log).put((Object)GNSBlocks.dead_wood, (Object)GNSBlocks.stripped_dead_wood).put((Object)GNSBlocks.blood_log, (Object)GNSBlocks.stripped_blood_log).put((Object)GNSBlocks.blood_wood, (Object)GNSBlocks.stripped_blood_wood).build();
    public static final Map<Block, BlockState> BLOCK_TILL_MAP = new ImmutableMap.Builder().put((Object)GNSBlocks.dream_grass_block, (Object)GNSBlocks.dream_farmland.func_176223_P()).put((Object)GNSBlocks.dream_dirt, (Object)GNSBlocks.dream_farmland.func_176223_P()).put((Object)GNSBlocks.nightmare_grass_block, (Object)Blocks.field_150458_ak.func_176223_P()).build();
    public PlayerEntity player;
    public boolean hasTeleported = false;
    public boolean inPortal = false;
    public int timeInPortal;
    public float prevPortalAnimTime;
    public float portalAnimTime;

    @SubscribeEvent
    public void onRegisteredDimension(RegisterDimensionsEvent event) {
        GNSDimensions.initDimensions();
    }

    @SubscribeEvent
    public void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)GNSEvents.rayTrace(world, player);
        BlockPos pos = rayTraceResult.func_216350_a();
        if (event.getItemStack().func_77973_b() instanceof AxeItem) {
            BlockState blockState = world.func_180495_p(pos);
            Block block = BLOCK_STRIPPING_MAP.get(blockState.func_177230_c());
            if (block != null) {
                player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, (BlockState)block.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                    if (player != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                    }
                }
            }
            event.setCanceled(true);
        }
        if (event.getItemStack().func_77973_b() instanceof HoeItem) {
            BlockState dirtState = world.func_180495_p(pos);
            BlockState resultState = BLOCK_TILL_MAP.get(dirtState.func_177230_c());
            if (resultState != null && event.getFace() != Direction.DOWN && world.func_175623_d(pos.func_177984_a())) {
                player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, resultState, 11);
                    if (player != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                    }
                }
            }
            event.setCanceled(true);
        }
    }

    protected static RayTraceResult rayTrace(World worldIn, PlayerEntity player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)player));
    }
}

