/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep;

import com.legacy.goodnightsleep.GNSConfig;
import com.legacy.goodnightsleep.GNSEvents;
import com.legacy.goodnightsleep.blocks.GNSBlocks;
import com.legacy.goodnightsleep.client.GoodNightSleepClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BushConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="goodnightsleep")
public class GoodNightSleep {
    public static final String NAME = "Good Night's Sleep";
    public static final String MODID = "goodnightsleep";

    public GoodNightSleep() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, GNSConfig.SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::initialization);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(GoodNightSleepClient::initialization);
            MinecraftForge.EVENT_BUS.register((Object)new GoodNightSleepClient());
        });
    }

    private void initialization(FMLCommonSetupEvent event) {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (!biome.getRegistryName().func_110624_b().equalsIgnoreCase("minecraft") || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.VOID)) continue;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(GNSBlocks.despair_mushroom.func_176223_P()), (Placement)Placement.field_215032_r, (IPlacementConfig)new ChanceRangeConfig(0.3f, 0, 0, 128)));
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(GNSBlocks.hope_mushroom.func_176223_P()), (Placement)Placement.field_215032_r, (IPlacementConfig)new ChanceRangeConfig(0.3f, 0, 0, 128)));
                continue;
            }
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(GNSBlocks.despair_mushroom.func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(4)));
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202284_ad, (IFeatureConfig)new BushConfig(GNSBlocks.hope_mushroom.func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(8)));
        }
        MinecraftForge.EVENT_BUS.register((Object)new GNSEvents());
    }

    public static ResourceLocation locate(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static String find(String name) {
        return "goodnightsleep:" + name;
    }
}

