/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.blocks;

import com.legacy.goodnightsleep.blocks.GNSBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class RainbowBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final IntegerProperty CORNER_TYPE = IntegerProperty.func_177719_a((String)"corner_type", (int)0, (int)2);
    public static final IntegerProperty SIDE_TYPE = IntegerProperty.func_177719_a((String)"side_type", (int)0, (int)2);
    public static final IntegerProperty DISTANCE = IntegerProperty.func_177719_a((String)"distance", (int)0, (int)100);

    public RainbowBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X)).func_206870_a((IProperty)CORNER_TYPE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)SIDE_TYPE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int i = RainbowBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.func_177229_b((IProperty)DISTANCE) != i) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return stateIn;
    }

    private static int getDistance(BlockState neighbor) {
        if (neighbor.func_177230_c() == GNSBlocks.pot_of_gold) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof RainbowBlock ? (Integer)neighbor.func_177229_b((IProperty)DISTANCE) : 100;
    }

    private static BlockState updateDistance(BlockState state, IWorld worldIn, BlockPos pos) {
        int i = 100;
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (Direction direction : Direction.values()) {
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(direction);
                i = Math.min(i, RainbowBlock.getDistance(worldIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)) + 1);
                if (i != 1) continue;
                break;
            }
        }
        return (BlockState)state.func_206870_a((IProperty)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        worldIn.func_180501_a(pos, RainbowBlock.updateDistance(state, (IWorld)worldIn, pos), 3);
        if ((Integer)state.func_177229_b((IProperty)DISTANCE) >= 100) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS, CORNER_TYPE, SIDE_TYPE, DISTANCE});
    }
}

