/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.client.render.entity;

import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.client.render.models.BabyCreeperModel;
import com.legacy.goodnightsleep.entity.dream.BabyCreeperEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BabyCreeperRenderer
extends MobRenderer<BabyCreeperEntity, BabyCreeperModel<BabyCreeperEntity>> {
    private static final ResourceLocation TEXTURE = GoodNightSleep.locate("textures/entities/baby_creeper.png");

    public BabyCreeperRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new BabyCreeperModel(), 0.5f);
    }

    protected void preRenderCallback(BabyCreeperEntity entitylivingbaseIn, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        GlStateManager.scalef((float)f2, (float)f3, (float)f2);
    }

    protected int getColorMultiplier(BabyCreeperEntity entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        float f = entitylivingbaseIn.getCreeperFlashIntensity(partialTickTime);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f * 0.2f * 255.0f);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)255);
        return i << 24 | 0x30FFFFFF;
    }

    protected ResourceLocation getEntityTexture(BabyCreeperEntity entity) {
        return TEXTURE;
    }
}

