/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.entity;

import com.legacy.goodnightsleep.GNSRegistry;
import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.blocks.GNSBlocks;
import com.legacy.goodnightsleep.entity.GNSSpawnerEntity;
import com.legacy.goodnightsleep.entity.HerobrineEntity;
import com.legacy.goodnightsleep.entity.TormenterEntity;
import com.legacy.goodnightsleep.entity.dream.BabyCreeperEntity;
import com.legacy.goodnightsleep.entity.dream.GummyBearEntity;
import com.legacy.goodnightsleep.entity.dream.UnicornEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="goodnightsleep")
public class GNSEntityTypes {
    public static final EntityType<UnicornEntity> UNICORN = GNSEntityTypes.buildEntity("unicorn", EntityType.Builder.func_220322_a(UnicornEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f));
    public static final EntityType<GummyBearEntity> GUMMY_BEAR = GNSEntityTypes.buildEntity("gummy_bear", EntityType.Builder.func_220322_a(GummyBearEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.7f));
    public static final EntityType<BabyCreeperEntity> BABY_CREEPER = GNSEntityTypes.buildEntity("baby_creeper", EntityType.Builder.func_220322_a(BabyCreeperEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.3f));
    public static final EntityType<TormenterEntity> TORMENTER = GNSEntityTypes.buildEntity("tormenter", EntityType.Builder.func_220322_a(TormenterEntity::new, (EntityClassification)EntityClassification.MONSTER));
    public static final EntityType<HerobrineEntity> HEROBRINE = GNSEntityTypes.buildEntity("herobrine", EntityType.Builder.func_220322_a(HerobrineEntity::new, (EntityClassification)EntityClassification.MONSTER));
    public static final EntityType<GNSSpawnerEntity> SPAWNER_ENTITY = GNSEntityTypes.buildEntity("gns_spawner", EntityType.Builder.func_220322_a(GNSSpawnerEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.0f, 1.0f));

    public static void init(RegistryEvent.Register<EntityType<?>> event) {
        GNSRegistry.register(event.getRegistry(), "unicorn", UNICORN);
        GNSRegistry.register(event.getRegistry(), "gummy_bear", GUMMY_BEAR);
        GNSRegistry.register(event.getRegistry(), "baby_creeper", BABY_CREEPER);
        GNSRegistry.register(event.getRegistry(), "tormenter", TORMENTER);
        GNSRegistry.register(event.getRegistry(), "herobrine", HEROBRINE);
        GNSRegistry.register(event.getRegistry(), "gns_spawner", SPAWNER_ENTITY);
        EntitySpawnPlacementRegistry.func_209343_a(TORMENTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(HEROBRINE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(BABY_CREEPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(UNICORN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GNSEntityTypes::animalSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(GUMMY_BEAR, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GNSEntityTypes::animalSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(SPAWNER_ENTITY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GNSEntityTypes::otherSpawnConditions);
    }

    public static boolean animalSpawnConditions(EntityType<? extends AnimalEntity> p_223316_0_, IWorld p_223316_1_, SpawnReason p_223316_2_, BlockPos p_223316_3_, Random p_223316_4_) {
        return p_223316_1_.func_180495_p(p_223316_3_.func_177977_b()).func_177230_c() == GNSBlocks.dream_grass_block && p_223316_1_.func_201669_a(p_223316_3_, 0) > 8;
    }

    public static boolean otherSpawnConditions(EntityType<? extends MobEntity> p_223316_0_, IWorld p_223316_1_, SpawnReason p_223316_2_, BlockPos p_223316_3_, Random p_223316_4_) {
        return (p_223316_1_.func_180495_p(p_223316_3_.func_177977_b()).func_177230_c() == GNSBlocks.nightmare_grass_block || p_223316_1_.func_180495_p(p_223316_3_.func_177977_b()).func_177230_c() == GNSBlocks.dream_grass_block) && p_223316_1_.func_217337_f(p_223316_3_);
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.func_206830_a(GoodNightSleep.find(key));
    }
}

