/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.world.general_features;

import com.legacy.goodnightsleep.GNSRegistry;
import com.legacy.goodnightsleep.blocks.GNSBlocks;
import com.legacy.goodnightsleep.world.dream.features.BigHopeMushroomFeature;
import com.legacy.goodnightsleep.world.dream.features.DreamOreFeature;
import com.legacy.goodnightsleep.world.dream.features.DreamOreFeatureConfig;
import com.legacy.goodnightsleep.world.dream.features.DreamSpongeFeature;
import com.legacy.goodnightsleep.world.dream.features.DreamTreeFeature;
import com.legacy.goodnightsleep.world.dream.features.GNSBigTreeFeature;
import com.legacy.goodnightsleep.world.dream.features.GNSFlowersFeature;
import com.legacy.goodnightsleep.world.general_features.DreamScatteredPlantFeature;
import com.legacy.goodnightsleep.world.nightmare.features.BigDespairMushroomFeature;
import com.legacy.goodnightsleep.world.nightmare.features.NetherSplashFeature;
import com.legacy.goodnightsleep.world.nightmare.features.NightmareFlowersFeature;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="goodnightsleep")
public class GNSFeatures {
    public static final AbstractTreeFeature<NoFeatureConfig> DREAM_TREE = new DreamTreeFeature(NoFeatureConfig::func_214639_a, false);
    public static final AbstractTreeFeature<NoFeatureConfig> CANDY_TREE = new DreamTreeFeature(NoFeatureConfig::func_214639_a, false, 5, GNSBlocks.white_log.func_176223_P(), GNSBlocks.candy_leaves.func_176223_P());
    public static final AbstractTreeFeature<NoFeatureConfig> DIAMOND_TREE = new GNSBigTreeFeature(NoFeatureConfig::func_214639_a, false, GNSBlocks.dream_log.func_176223_P(), GNSBlocks.diamond_leaves.func_176223_P());
    public static final AbstractTreeFeature<NoFeatureConfig> DEAD_TREE = new GNSBigTreeFeature(NoFeatureConfig::func_214639_a, false, GNSBlocks.dead_log.func_176223_P(), Blocks.field_150350_a.func_176223_P());
    public static final AbstractTreeFeature<NoFeatureConfig> BLOOD_TREE = new DreamTreeFeature(NoFeatureConfig::func_214639_a, false, 5, GNSBlocks.blood_log.func_176223_P(), Blocks.field_150350_a.func_176223_P());
    public static final Feature<NoFeatureConfig> DREAM_SPONGE = new DreamSpongeFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> DREAM_FLOWERS = new GNSFlowersFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> BIG_HOPE_MUSHROOM = new BigHopeMushroomFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> SCATTERED_PRESENTS = new DreamScatteredPlantFeature(NoFeatureConfig::func_214639_a, GNSBlocks.present.func_176223_P());
    public static final Feature<DreamOreFeatureConfig> DREAM_ORES = new DreamOreFeature(DreamOreFeatureConfig::deserialize);
    public static final Feature<NoFeatureConfig> NETHER_SPLASH = new NetherSplashFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> NIGHTMARE_FLOWERS = new NightmareFlowersFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> HUGE_DESPAIR_MUSHROOM = new BigDespairMushroomFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> SCATTERED_PUMPKINS = new DreamScatteredPlantFeature(NoFeatureConfig::func_214639_a, Blocks.field_150423_aK.func_176223_P());

    public static void init(RegistryEvent.Register<Feature<?>> event) {
        GNSRegistry.register(event.getRegistry(), "dream_tree", DREAM_TREE);
        GNSRegistry.register(event.getRegistry(), "candy_tree", CANDY_TREE);
        GNSRegistry.register(event.getRegistry(), "diamond_tree", DIAMOND_TREE);
        GNSRegistry.register(event.getRegistry(), "dead_tree", DEAD_TREE);
        GNSRegistry.register(event.getRegistry(), "blood_tree", BLOOD_TREE);
        GNSRegistry.register(event.getRegistry(), "dream_sponge", DREAM_SPONGE);
        GNSRegistry.register(event.getRegistry(), "dream_flowers", DREAM_FLOWERS);
        GNSRegistry.register(event.getRegistry(), "big_hope_mushroom", BIG_HOPE_MUSHROOM);
        GNSRegistry.register(event.getRegistry(), "scattered_presents", SCATTERED_PRESENTS);
        GNSRegistry.register(event.getRegistry(), "dream_ores", DREAM_ORES);
        GNSRegistry.register(event.getRegistry(), "nether_splash", NETHER_SPLASH);
        GNSRegistry.register(event.getRegistry(), "nightmare_flowers", NIGHTMARE_FLOWERS);
        GNSRegistry.register(event.getRegistry(), "big_despair_mushroom", HUGE_DESPAIR_MUSHROOM);
        GNSRegistry.register(event.getRegistry(), "scattered_pumpkins", SCATTERED_PUMPKINS);
    }

    public static void addDreamOres(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(DREAM_ORES, (IFeatureConfig)new DreamOreFeatureConfig(DreamOreFeatureConfig.FillerBlockType.DELUSION, GNSBlocks.dream_dirt.func_176223_P(), 33), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 0, 0, 256)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(DREAM_ORES, (IFeatureConfig)new DreamOreFeatureConfig(DreamOreFeatureConfig.FillerBlockType.DELUSION, GNSBlocks.coal_ore.func_176223_P(), 17), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(20, 0, 0, 128)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(DREAM_ORES, (IFeatureConfig)new DreamOreFeatureConfig(DreamOreFeatureConfig.FillerBlockType.DELUSION, GNSBlocks.candy_ore.func_176223_P(), 14), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(20, 0, 0, 128)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(DREAM_ORES, (IFeatureConfig)new DreamOreFeatureConfig(DreamOreFeatureConfig.FillerBlockType.DELUSION, GNSBlocks.rainbow_ore.func_176223_P(), 9), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(20, 0, 0, 64)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(DREAM_ORES, (IFeatureConfig)new DreamOreFeatureConfig(DreamOreFeatureConfig.FillerBlockType.DELUSION, GNSBlocks.positite_ore.func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 0, 0, 16)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(DREAM_ORES, (IFeatureConfig)new DreamOreFeatureConfig(DreamOreFeatureConfig.FillerBlockType.DELUSION, GNSBlocks.lapis_ore.func_176223_P(), 7), (Placement)Placement.field_215035_u, (IPlacementConfig)new DepthAverageConfig(1, 16, 16)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(DREAM_ORES, (IFeatureConfig)new DreamOreFeatureConfig(DreamOreFeatureConfig.FillerBlockType.DELUSION, Blocks.field_150426_aN.func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 0, 0, 7)));
    }

    public static void addDreamTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(DREAM_TREE, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.6f, 1)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(CANDY_TREE, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(DIAMOND_TREE, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.2f, 1)));
    }

    public static void addScatteredDreamFeatures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.RAW_GENERATION, Biome.func_222280_a(DREAM_SPONGE, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(20)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(DREAM_FLOWERS, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(5)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(BIG_HOPE_MUSHROOM, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.3f, 1)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(SCATTERED_PRESENTS, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(32)));
    }

    public static void addNightmareOres(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150346_d.func_176223_P(), 33), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 0, 0, 256)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150351_n.func_176223_P(), 33), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(8, 0, 0, 256)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150365_q.func_176223_P(), 17), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(20, 0, 0, 128)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, GNSBlocks.necrum_ore.func_176223_P(), 14), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(20, 0, 0, 128)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150366_p.func_176223_P(), 7), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(20, 0, 0, 64)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, GNSBlocks.zitrite_ore.func_176223_P(), 9), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(5, 0, 0, 32)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150352_o.func_176223_P(), 9), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 0, 0, 32)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, GNSBlocks.negatite_ore.func_176223_P(), 3), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 0, 0, 16)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150369_x.func_176223_P(), 7), (Placement)Placement.field_215035_u, (IPlacementConfig)new DepthAverageConfig(1, 16, 16)));
    }

    public static void addNightmareTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(DEAD_TREE, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 1)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(BLOOD_TREE, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1)));
    }

    public static void addScatteredNightmareFeatures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.RAW_GENERATION, Biome.func_222280_a(NETHER_SPLASH, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(20)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(NIGHTMARE_FLOWERS, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(5)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(HUGE_DESPAIR_MUSHROOM, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(SCATTERED_PUMPKINS, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(10)));
    }
}

