/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep;

import com.legacy.goodnightsleep.VariableConstants;
import com.legacy.goodnightsleep.blocks.BlocksGNS;
import com.legacy.goodnightsleep.client.audio.GNSSounds;
import com.legacy.goodnightsleep.entity.GNSEntityTypes;
import com.legacy.goodnightsleep.item.GNSCreativeTabs;
import com.legacy.goodnightsleep.item.ItemsGNS;
import com.legacy.goodnightsleep.tile_entity.GNSTileEntityTypes;
import com.legacy.goodnightsleep.world.dream.BiomeGoodDreamPlains;
import com.legacy.goodnightsleep.world.dream.DreamWorldManager;
import com.legacy.goodnightsleep.world.nightmare.BiomeNightmareHills;
import com.legacy.goodnightsleep.world.nightmare.NightmareWorldManager;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="goodnightsleep", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GNSRegistryHandler {
    @SubscribeEvent
    public static void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
        GNSSounds.soundRegistry = event.getRegistry();
        GNSSounds.initialization();
    }

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        BlocksGNS.setBlockRegistry((IForgeRegistry<Block>)event.getRegistry());
        BlocksGNS.initialization();
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        ItemsGNS.setItemRegistry((IForgeRegistry<Item>)event.getRegistry());
        ItemsGNS.initialization();
        for (int i3 = 0; i3 < BlocksGNS.gnsBlockList.size(); ++i3) {
            GNSRegistryHandler.register(event.getRegistry(), BlocksGNS.gnsBlockList.get(i3).getRegistryName().toString().replace("goodnightsleep:", ""), new ItemBlock(BlocksGNS.gnsBlockList.get(i3), new Item.Properties().func_200916_a(GNSCreativeTabs.blocks)));
        }
    }

    @SubscribeEvent
    public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().register(GNSEntityTypes.UNICORN);
        event.getRegistry().register(GNSEntityTypes.GUMMY_BEAR);
        event.getRegistry().register(GNSEntityTypes.BABY_CREEPER);
        event.getRegistry().register(GNSEntityTypes.TORMENTER);
        event.getRegistry().register(GNSEntityTypes.HEROBRINE);
    }

    @SubscribeEvent
    public static void onRegisterTileEntityTypes(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register(GNSTileEntityTypes.LUXURIOUS_BED);
    }

    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        GNSRegistryHandler.register(event.getRegistry(), "good_dream_plains", new BiomeGoodDreamPlains());
        GNSRegistryHandler.register(event.getRegistry(), "nightmare_hills", new BiomeNightmareHills());
    }

    @SubscribeEvent
    public static void onRegisterDimensions(RegistryEvent.Register<ModDimension> event) {
        GNSRegistryHandler.register(event.getRegistry(), "good_dream", new DreamWorldManager());
        GNSRegistryHandler.register(event.getRegistry(), "nightmare", new NightmareWorldManager());
    }

    private static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String name, T object) {
        object.setRegistryName(VariableConstants.locate(name));
        registry.register(object);
    }
}

