/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.blocks;

import com.legacy.goodnightsleep.blocks.BlocksGNS;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockGNSFarmland
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.field_208133_ah;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    protected BlockGNSFarmland(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == EnumFacing.UP && !stateIn.func_196955_c((IWorldReaderBase)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
        return !iblockstate.func_185904_a().func_76220_a() || iblockstate.func_177230_c() instanceof BlockFenceGate;
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReaderBase)context.func_195991_k(), context.func_195995_a()) ? BlocksGNS.dream_dirt.func_176223_P() : super.func_196258_a(context);
    }

    public int func_200011_d(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_201572_C();
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return SHAPE;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (!state.func_196955_c((IWorldReaderBase)worldIn, pos)) {
            BlockGNSFarmland.turnToDirt(state, worldIn, pos);
        } else {
            int i = (Integer)state.func_177229_b((IProperty)MOISTURE);
            if (!BlockGNSFarmland.hasWater((IWorldReaderBase)worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
                if (i > 0) {
                    worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
                } else if (!this.hasCrops((IBlockReader)worldIn, pos)) {
                    BlockGNSFarmland.turnToDirt(state, worldIn, pos);
                }
            } else if (i < 7) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
            }
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && ForgeHooks.onFarmlandTrample((World)worldIn, (BlockPos)pos, (IBlockState)BlocksGNS.dream_dirt.func_176223_P(), (float)fallDistance, (Entity)entityIn)) {
            BlockGNSFarmland.turnToDirt(worldIn.func_180495_p(pos), worldIn, pos);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    public static void turnToDirt(IBlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, BlockGNSFarmland.func_199601_a((IBlockState)state, (IBlockState)BlocksGNS.dream_dirt.func_176223_P(), (World)worldIn, (BlockPos)pos));
    }

    private boolean hasCrops(IBlockReader p_176529_0_, BlockPos worldIn) {
        IBlockState state = p_176529_0_.func_180495_p(worldIn.func_177984_a());
        return state.func_177230_c() instanceof IPlantable && this.canSustainPlant(state, p_176529_0_, worldIn, EnumFacing.UP, (IPlantable)state.func_177230_c());
    }

    private static boolean hasWater(IWorldReaderBase p_176530_0_, BlockPos worldIn) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)worldIn.func_177982_a(-4, 0, -4), (BlockPos)worldIn.func_177982_a(4, 1, 4))) {
            if (!p_176530_0_.func_204610_c((BlockPos)blockpos$mutableblockpos).func_206884_a(FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReaderBase)p_176530_0_, (BlockPos)worldIn);
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return BlocksGNS.dream_dirt;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{MOISTURE});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

