/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.world.dream.features;

import com.google.common.collect.Lists;
import com.legacy.goodnightsleep.blocks.BlocksGNS;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class GNSBigTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private IBlockState LOG;
    private IBlockState LEAVES;

    public GNSBigTreeFeature(boolean notify, IBlockState log, IBlockState leaves) {
        super(notify);
        this.LEAVES = leaves;
        this.LOG = log;
    }

    private void crossSection(IWorld p_208529_1_, BlockPos p_208529_2_, float p_208529_3_) {
        int i = (int)((double)p_208529_3_ + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                BlockPos blockpos;
                IBlockState iblockstate;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(p_208529_3_ * p_208529_3_)) || !(iblockstate = p_208529_1_.func_180495_p(blockpos = p_208529_2_.func_177982_a(j, 0, k))).isAir((IBlockReader)p_208529_1_, blockpos) && iblockstate.func_185904_a() != Material.field_151584_j) continue;
                this.func_202278_a(p_208529_1_, blockpos, this.LEAVES);
            }
        }
    }

    private float treeShape(int p_208527_1_, int p_208527_2_) {
        if ((float)p_208527_2_ < (float)p_208527_1_ * 0.3f) {
            return -1.0f;
        }
        float f = (float)p_208527_1_ / 2.0f;
        float f1 = f - (float)p_208527_2_;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    private float foliageShape(int y) {
        if (y >= 0 && y < 5) {
            return y != 0 && y != 4 ? 3.0f : 2.0f;
        }
        return -1.0f;
    }

    private void foliageCluster(IWorld p_202393_1_, BlockPos p_202393_2_) {
        for (int i = 0; i < 5; ++i) {
            this.crossSection(p_202393_1_, p_202393_2_.func_177981_b(i), this.foliageShape(i));
        }
    }

    private int makeLimb(Set<BlockPos> p_208523_1_, IWorld p_208523_2_, BlockPos p_208523_3_, BlockPos p_208523_4_, boolean p_208523_5_) {
        if (!p_208523_5_ && Objects.equals(p_208523_3_, p_208523_4_)) {
            return -1;
        }
        BlockPos blockpos = p_208523_4_.func_177982_a(-p_208523_3_.func_177958_n(), -p_208523_3_.func_177956_o(), -p_208523_3_.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = p_208523_3_.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (p_208523_5_) {
                this.func_208520_a(p_208523_1_, p_208523_2_, blockpos1, (IBlockState)this.LOG.func_206870_a((IProperty)BlockLog.field_176298_M, (Comparable)this.getLoxAxis(p_208523_3_, blockpos1)));
                continue;
            }
            if (this.canGrowInto((IBlockReader)p_208523_2_, blockpos1)) continue;
            return j;
        }
        return -1;
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        if (k > i && k > j) {
            return k;
        }
        return j > i ? j : i;
    }

    private EnumFacing.Axis getLoxAxis(BlockPos p_197170_1_, BlockPos p_197170_2_) {
        int j;
        EnumFacing.Axis enumfacing$axis = EnumFacing.Axis.Y;
        int i = Math.abs(p_197170_2_.func_177958_n() - p_197170_1_.func_177958_n());
        int k = Math.max(i, j = Math.abs(p_197170_2_.func_177952_p() - p_197170_1_.func_177952_p()));
        if (k > 0) {
            if (i == k) {
                enumfacing$axis = EnumFacing.Axis.X;
            } else if (j == k) {
                enumfacing$axis = EnumFacing.Axis.Z;
            }
        }
        return enumfacing$axis;
    }

    private void makeFoliage(IWorld p_208525_1_, int p_208525_2_, BlockPos p_208525_3_, List<FoliageCoordinates> p_208525_4_) {
        for (FoliageCoordinates bigtreefeature$foliagecoordinates : p_208525_4_) {
            if (!this.trimBranches(p_208525_2_, bigtreefeature$foliagecoordinates.getBranchBase() - p_208525_3_.func_177956_o())) continue;
            this.foliageCluster(p_208525_1_, bigtreefeature$foliagecoordinates);
        }
    }

    private boolean trimBranches(int p_208522_1_, int p_208522_2_) {
        return (double)p_208522_2_ >= (double)p_208522_1_ * 0.2;
    }

    private void makeTrunk(Set<BlockPos> p_208526_1_, IWorld p_208526_2_, BlockPos p_208526_3_, int p_208526_4_) {
        this.makeLimb(p_208526_1_, p_208526_2_, p_208526_3_, p_208526_3_.func_177981_b(p_208526_4_), true);
    }

    private void makeBranches(Set<BlockPos> p_208524_1_, IWorld p_208524_2_, int p_208524_3_, BlockPos p_208524_4_, List<FoliageCoordinates> p_208524_5_) {
        for (FoliageCoordinates bigtreefeature$foliagecoordinates : p_208524_5_) {
            int i = bigtreefeature$foliagecoordinates.getBranchBase();
            BlockPos blockpos = new BlockPos(p_208524_4_.func_177958_n(), i, p_208524_4_.func_177952_p());
            if (blockpos.equals((Object)bigtreefeature$foliagecoordinates) || !this.trimBranches(p_208524_3_, i - p_208524_4_.func_177956_o())) continue;
            this.makeLimb(p_208524_1_, p_208524_2_, blockpos, bigtreefeature$foliagecoordinates, true);
        }
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld worldIn, Random rand, BlockPos position) {
        int i1;
        Random random = new Random(rand.nextLong());
        int i = this.checkLocation(changedBlocks, worldIn, position, 5 + random.nextInt(12));
        if (i == -1) {
            return false;
        }
        this.setDirtAt(worldIn, position.func_177977_b(), position);
        int j = (int)((double)i * 0.618);
        if (j >= i) {
            j = i - 1;
        }
        double d0 = 1.0;
        int k = (int)(1.382 + Math.pow(1.0 * (double)i / 13.0, 2.0));
        if (k < 1) {
            k = 1;
        }
        int l = position.func_177956_o() + j;
        ArrayList list = Lists.newArrayList();
        list.add(new FoliageCoordinates(position.func_177981_b(i1), l));
        for (i1 = i - 5; i1 >= 0; --i1) {
            float f = this.treeShape(i, i1);
            if (f < 0.0f) continue;
            for (int j1 = 0; j1 < k; ++j1) {
                BlockPos blockpos1;
                double d5;
                double d3;
                double d1 = 1.0;
                double d2 = 1.0 * (double)f * ((double)random.nextFloat() + 0.328);
                double d4 = d2 * Math.sin(d3 = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = position.func_177963_a(d4, (double)(i1 - 1), d5 = d2 * Math.cos(d3) + 0.5);
                if (this.makeLimb(changedBlocks, worldIn, blockpos, blockpos1 = blockpos.func_177981_b(5), false) != -1) continue;
                int k1 = position.func_177958_n() - blockpos.func_177958_n();
                int l1 = position.func_177952_p() - blockpos.func_177952_p();
                double d6 = (double)blockpos.func_177956_o() - Math.sqrt(k1 * k1 + l1 * l1) * 0.381;
                int i2 = d6 > (double)l ? l : (int)d6;
                BlockPos blockpos2 = new BlockPos(position.func_177958_n(), i2, position.func_177952_p());
                if (this.makeLimb(changedBlocks, worldIn, blockpos2, blockpos, false) != -1) continue;
                list.add(new FoliageCoordinates(blockpos, blockpos2.func_177956_o()));
            }
        }
        this.makeFoliage(worldIn, i, position, list);
        this.makeTrunk(changedBlocks, worldIn, position, j);
        this.makeBranches(changedBlocks, worldIn, i, position, list);
        return true;
    }

    private int checkLocation(Set<BlockPos> p_208528_1_, IWorld world, BlockPos pos, int p_208528_4_) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != BlocksGNS.dream_grass_block && world.func_180495_p(pos.func_177977_b()).func_177230_c() != BlocksGNS.nightmare_grass_block) {
            return -1;
        }
        int i = this.makeLimb(p_208528_1_, world, pos, pos.func_177981_b(p_208528_4_ - 1), false);
        if (i == -1) {
            return p_208528_4_;
        }
        return i < 6 ? -1 : i;
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int p_i45635_2_) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = p_i45635_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

