/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.configuration;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="guardvillagers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuardConfig {
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static boolean GuardModel;
    public static boolean RaidAnimals;
    public static boolean WitchesVillager;
    public static boolean IllusionerRaids;
    public static boolean AttackAllMobs;
    public static boolean GuardSurrender;

    public static void bakeConfig() {
        GuardModel = (Boolean)GuardConfig.CLIENT.GuardModel.get();
        RaidAnimals = (Boolean)GuardConfig.CLIENT.RaidAnimals.get();
        WitchesVillager = (Boolean)GuardConfig.CLIENT.WitchesVillager.get();
        IllusionerRaids = (Boolean)GuardConfig.CLIENT.IllusionerRaids.get();
        AttackAllMobs = (Boolean)GuardConfig.CLIENT.AttackAllMobs.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            GuardConfig.bakeConfig();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue GuardModel;
        public final ForgeConfigSpec.BooleanValue RaidAnimals;
        public final ForgeConfigSpec.BooleanValue WitchesVillager;
        public final ForgeConfigSpec.BooleanValue IllusionerRaids;
        public final ForgeConfigSpec.BooleanValue AttackAllMobs;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.GuardModel = builder.comment("Switch Guard Model To Vanilla Style?, (textures not completed yet)").translation("guardvillagers.config.GuardModel").define("Vanilla Styled Model?", false);
            this.RaidAnimals = builder.comment("Illagers In Raids Attack Animals?").translation("guardvillagers.config.RaidAnimals").define("Illagers In Raids Attack Animals?", false);
            this.WitchesVillager = builder.comment("Witches Attack Villagers?").translation("guardvillagers.config.WitchesVillager").define("Witches Attack Villagers?", true);
            this.IllusionerRaids = builder.comment("Illusioners in Raids?").translation("guardvillagers.config.IllusionerRaids").define("Illusioners in Raids?", true);
            this.AttackAllMobs = builder.comment("Guards Attack All Mobs?").translation("guardvillagers.config.AttackAllMobs").define("Guards Attack All Mobs?", false);
        }
    }
}

