/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.MoveTowardsVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import tallestegg.guardvillagers.configuration.GuardConfig;

public class GuardEntity
extends CreatureEntity {
    private static final DataParameter<Integer> GUARD_VARIANT = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public GuardEntity(EntityType<? extends GuardEntity> type, World world) {
        super(type, world);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int type = GuardEntity.getRandomTypeForBiome(worldIn, this.func_180425_c());
        if (spawnDataIn instanceof GuardData) {
            type = ((GuardData)spawnDataIn).variantData;
            spawnDataIn = new GuardData(type);
        }
        this.setGuardVariant(type);
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setGuardVariant(compound.func_74762_e("Type"));
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GUARD_VARIANT, (Object)0);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
        this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 50.0f;
    }

    public int getGuardVariant() {
        return (Integer)this.field_70180_af.func_187225_a(GUARD_VARIANT);
    }

    public void setGuardVariant(int typeId) {
        this.field_70180_af.func_187227_b(GUARD_VARIANT, (Object)typeId);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsVillageGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new AvoidEntityGoal<RavagerEntity>((CreatureEntity)this, RavagerEntity.class, 12.0f, 0.5, 0.5){

            public boolean func_75250_a() {
                return ((GuardEntity)this.field_75380_a).func_110143_aJ() <= 13.0f && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal<RavagerEntity>((MobEntity)this, RavagerEntity.class, true){

            public boolean func_75250_a() {
                return ((GuardEntity)this.field_75299_d).func_110143_aJ() >= 13.0f && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractIllagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WitchEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IllusionerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, VexEntity.class, true));
        if (GuardConfig.AttackAllMobs) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, mob -> mob instanceof IMob));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Type", this.getGuardVariant());
    }

    public static int getRandomTypeForBiome(IWorld world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (biome.func_201856_r() == Biome.Category.PLAINS) {
            return 0;
        }
        if (biome.func_201856_r() == Biome.Category.DESERT) {
            return 1;
        }
        if (biome.func_201856_r() == Biome.Category.SAVANNA) {
            return 2;
        }
        if (biome.func_201856_r() == Biome.Category.SWAMP) {
            return 3;
        }
        if (biome.func_201856_r() == Biome.Category.JUNGLE) {
            return 4;
        }
        if (biome.func_201856_r() == Biome.Category.TAIGA) {
            return 5;
        }
        if (biome.func_201856_r() == Biome.Category.ICY) {
            return 6;
        }
        return 0;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() instanceof SwordItem && player.func_70093_af()) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, heldStack.func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
        }
        return true;
    }

    public static String getNameByType(int id) {
        switch (id) {
            case 0: {
                return "plains";
            }
            case 1: {
                return "desert";
            }
            case 2: {
                return "savanna";
            }
            case 3: {
                return "swamp";
            }
            case 4: {
                return "jungle";
            }
            case 5: {
                return "taiga";
            }
            case 6: {
                return "snow";
            }
        }
        return "";
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public static class GuardData
    implements ILivingEntityData {
        public final int variantData;

        public GuardData(int type) {
            this.variantData = type;
        }
    }
}

