/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.ModConfig;
import net.blay09.mods.hardcorerevival.PlayerKnockedOutEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PingAddon {
    private boolean isEnabled;
    private GuiButton buttonPing;
    private Object pingType;
    private Method sendPingMethod;

    public PingAddon() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            Class<?> pingTypeClass = Class.forName("dmillerw.ping.data.PingType");
            this.pingType = pingTypeClass.getEnumConstants()[1];
            Class<?> clientProxyClass = Class.forName("dmillerw.ping.proxy.ClientProxy");
            this.sendPingMethod = clientProxyClass.getMethod("sendPing", pingTypeClass);
            if (!Modifier.isPublic(this.sendPingMethod.getModifiers()) || !Modifier.isStatic(this.sendPingMethod.getModifiers())) {
                throw new Exception("sendPing is no longer accessible or not static");
            }
            this.isEnabled = true;
        }
        catch (Exception e) {
            HardcoreRevival.logger.error("Internal names for Ping have changed - disabled Ping integration.", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (this.isEnabled && gui.field_146297_k.field_71439_g != null && gui.field_146297_k.field_71439_g.func_110143_aJ() <= 0.0f && gui instanceof GuiChat) {
            this.buttonPing = new GuiButton(-999, gui.field_146294_l / 2 - 100, gui.field_146295_m / 2 + 30, I18n.func_135052_a((String)"gui.hardcorerevival.send_ping", (Object[])new Object[0]));
            event.getButtonList().add(this.buttonPing);
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (this.isEnabled && event.getButton() == this.buttonPing) {
            Minecraft mc = Minecraft.func_71410_x();
            this.buttonPing.func_146113_a(mc.func_147118_V());
            if (mc.field_71439_g != null) {
                this.sendPingBelowPlayer((EntityPlayer)mc.field_71439_g);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerKnockedOut(PlayerKnockedOutEvent event) {
        if (ModConfig.autoPingOnDeath) {
            this.sendPingBelowPlayer(event.getPlayer());
        }
    }

    private void sendPingBelowPlayer(EntityPlayer player) {
        float prevPitch = player.field_70125_A;
        player.field_70125_A = 90.0f;
        try {
            this.sendPingMethod.invoke(null, this.pingType);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            HardcoreRevival.logger.error("An exception occurred when sending the ping - disabled Ping integration.", (Throwable)e);
            this.isEnabled = false;
        }
        player.field_70125_A = prevPitch;
    }
}

