/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.PlayerKnockedOutEvent;
import net.blay09.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.IHardcoreRevival;
import net.blay09.mods.hardcorerevival.network.MessageDie;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class DeathHandler {
    public static final String IGNORE_REVIVAL_DEATH = "IgnoreRevivalDeath";

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            MinecraftServer server;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (event.getSource() == DamageSource.field_76380_i) {
                player.getPersistentData().func_74757_a(IGNORE_REVIVAL_DEATH, true);
                NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageDie());
                return;
            }
            if (event.getSource() == HardcoreRevival.notRescuedInTime || player.getPersistentData().func_74767_n(IGNORE_REVIVAL_DEATH)) {
                return;
            }
            MinecraftForge.EVENT_BUS.post((Event)new PlayerKnockedOutEvent(player, event.getSource()));
            if (((Boolean)HardcoreRevivalConfig.COMMON.glowOnDeath.get()).booleanValue()) {
                player.func_184195_f(true);
            }
            event.setCanceled(true);
            if (player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l) && (server = player.field_70170_p.func_73046_m()) != null) {
                Team team = player.func_96124_cp();
                if (team != null && team.func_178771_j() != Team.Visible.ALWAYS) {
                    if (team.func_178771_j() == Team.Visible.HIDE_FOR_OTHER_TEAMS) {
                        server.func_184103_al().func_177453_a(player, player.func_110142_aN().func_151521_b());
                    } else if (team.func_178771_j() == Team.Visible.HIDE_FOR_OWN_TEAM) {
                        server.func_184103_al().func_177452_b(player, player.func_110142_aN().func_151521_b());
                    }
                } else {
                    server.func_184103_al().func_148539_a(player.func_110142_aN().func_151521_b());
                }
            }
        }
    }

    @SubscribeEvent
    public void onDeathUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.func_110143_aJ() <= 0.0f && !event.player.getPersistentData().func_74767_n(IGNORE_REVIVAL_DEATH)) {
            if (event.player.field_70725_aQ == 19) {
                event.player.field_70725_aQ = 18;
            }
            LazyOptional revival = event.player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY);
            revival.ifPresent(it -> {
                it.setDeathTime(it.getDeathTime() + 1);
                if (!((Boolean)HardcoreRevivalConfig.COMMON.disableDeathTimer.get()).booleanValue() && it.getDeathTime() >= (Integer)HardcoreRevivalConfig.COMMON.maxDeathTicks.get()) {
                    DeathHandler.finalDeath(event.player, it);
                }
            });
        }
    }

    public static void finalDeath(PlayerEntity player, IHardcoreRevival it) {
        player.getPersistentData().func_74757_a(IGNORE_REVIVAL_DEATH, true);
        NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageDie());
        player.func_110142_aN().func_94547_a(HardcoreRevival.notRescuedInTime, 0.0f, 0.0f);
        player.func_70645_a(HardcoreRevival.notRescuedInTime);
        it.setDeathTime(0);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        event.getPlayer().getPersistentData().func_82580_o(IGNORE_REVIVAL_DEATH);
        if (((Boolean)HardcoreRevivalConfig.COMMON.glowOnDeath.get()).booleanValue()) {
            event.getPlayer().func_184195_f(false);
        }
        LazyOptional revival = event.getPlayer().getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> it.setDeathTime(0));
    }
}

