/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.hardcorerevival.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.IHardcoreRevival;
import net.blay09.mods.hardcorerevival.network.MessageDeathTime;
import net.blay09.mods.hardcorerevival.network.MessageDie;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class PlayerHandler {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            CompoundNBT data = player.getPersistentData().func_74775_l("PlayerPersisted");
            LazyOptional revival = player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
            revival.ifPresent(it -> CapabilityHardcoreRevival.REVIVAL_CAPABILITY.readNBT(it, null, (INBT)data.func_74775_l("HardcoreRevival")));
            NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageDeathTime((Integer)revival.map(IHardcoreRevival::getDeathTime).orElse((Object)0)));
            revival.ifPresent(it -> {
                if (!((Boolean)HardcoreRevivalConfig.COMMON.disableDeathTimer.get()).booleanValue() && it.getDeathTime() >= (Integer)HardcoreRevivalConfig.COMMON.maxDeathTicks.get()) {
                    NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageDie());
                }
            });
        }
    }

    @SubscribeEvent
    public void onCapabilityInject(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayerEntity) {
            event.addCapability(CapabilityHardcoreRevival.REGISTRY_NAME, new ICapabilityProvider(){
                private LazyOptional<IHardcoreRevival> revival;

                private LazyOptional<IHardcoreRevival> getRevivalCapabilityInstance() {
                    if (this.revival == null) {
                        IHardcoreRevival instance = (IHardcoreRevival)CapabilityHardcoreRevival.REVIVAL_CAPABILITY.getDefaultInstance();
                        this.revival = LazyOptional.of(() -> Objects.requireNonNull(instance));
                    }
                    return this.revival;
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
                    return CapabilityHardcoreRevival.REVIVAL_CAPABILITY.orEmpty(cap, this.getRevivalCapabilityInstance());
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerEntity player = event.getPlayer();
        CompoundNBT data = player.getPersistentData().func_74775_l("PlayerPersisted");
        LazyOptional revival = player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> {
            INBT tag = CapabilityHardcoreRevival.REVIVAL_CAPABILITY.writeNBT(it, null);
            if (tag != null) {
                data.func_218657_a("HardcoreRevival", tag);
                player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)data);
            }
        });
    }
}

