/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.hardcorerevival.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.capability.CapabilityHardcoreRevival;
import net.blay09.mods.hardcorerevival.network.MessageRevivalProgress;
import net.blay09.mods.hardcorerevival.network.MessageRevivalSuccess;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.PacketDistributor;

public class RescueHandler {
    @SubscribeEvent
    public void onItemUse(LivingEntityUseItemEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            RescueHandler.abortRescue((PlayerEntity)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        RescueHandler.abortRescue(event.getEntityPlayer());
    }

    public static void startRescue(PlayerEntity player, PlayerEntity target) {
        LazyOptional revival = player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> {
            it.setRescueTarget(target);
            it.setRescueTime(0);
            NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageRevivalProgress(target.func_145782_y(), 0.0f));
        });
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            LazyOptional revival = event.player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
            revival.ifPresent(it -> {
                if (it.getRescueTarget() != null) {
                    if (it.getRescueTarget().field_70128_L) {
                        RescueHandler.abortRescue(event.player);
                    } else {
                        float dist = event.player.func_70032_d((Entity)it.getRescueTarget());
                        if ((double)dist > (Double)HardcoreRevivalConfig.COMMON.maxRescueDist.get()) {
                            RescueHandler.abortRescue(event.player);
                        } else {
                            int rescueTime = it.getRescueTime() + 1;
                            it.setRescueTime(rescueTime);
                            int step = (Integer)HardcoreRevivalConfig.COMMON.rescueTime.get() / 4;
                            if (rescueTime >= (Integer)HardcoreRevivalConfig.COMMON.rescueTime.get()) {
                                RescueHandler.finishRescue(event.player);
                            } else if (rescueTime % step == 0) {
                                NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.player), (Object)new MessageRevivalProgress(it.getRescueTarget().func_145782_y(), (float)rescueTime / (float)((Integer)HardcoreRevivalConfig.COMMON.rescueTime.get()).intValue()));
                            }
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity original = event.getOriginal();
        LazyOptional revival = original.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> {
            if (it.getDeathTime() > 0) {
                event.getEntityPlayer().func_70012_b(original.field_70165_t, original.field_70163_u, original.field_70161_v, 0.0f, 0.0f);
            }
        });
    }

    public static void finishRescue(PlayerEntity player) {
        LazyOptional revival = player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> {
            MinecraftServer server;
            PlayerEntity target = it.getRescueTarget();
            if (target != null && (server = target.func_184102_h()) != null) {
                ServerPlayerEntity newPlayer;
                BlockPos prevSpawnPos = target.getBedLocation(target.field_71093_bK);
                boolean prevSpawnForced = target.isSpawnForced(target.field_71093_bK);
                DimensionType prevSpawnDimension = target.getSpawnDimension();
                target.setSpawnPoint(target.func_180425_c(), true, target.field_71093_bK);
                if (((Boolean)HardcoreRevivalConfig.COMMON.glowOnDeath.get()).booleanValue()) {
                    target.func_184195_f(false);
                }
                ((ServerPlayerEntity)target).field_71135_a.field_147369_b = newPlayer = server.func_184103_al().func_72368_a((ServerPlayerEntity)target, target.field_71093_bK, true);
                newPlayer.func_70606_j((float)((Integer)HardcoreRevivalConfig.COMMON.rescueRespawnHealth.get()).intValue());
                newPlayer.func_71024_bL().func_75114_a(((Integer)HardcoreRevivalConfig.COMMON.rescueRespawnFoodLevel.get()).intValue());
                newPlayer.func_195064_c(new EffectInstance(Effects.field_76438_s, 600));
                newPlayer.func_195064_c(new EffectInstance(Effects.field_76437_t, 1200));
                newPlayer.field_71071_by.func_70455_b(target.field_71071_by);
                newPlayer.field_71068_ca = target.field_71068_ca;
                newPlayer.field_71067_cb = target.field_71067_cb;
                newPlayer.field_71106_cc = target.field_71106_cc;
                newPlayer.func_70066_B();
                newPlayer.func_70052_a(0, false);
                newPlayer.func_85040_s(target.func_71037_bA());
                newPlayer.setSpawnPoint(prevSpawnPos, prevSpawnForced, prevSpawnDimension);
                NetworkHandler.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), (Object)new MessageRevivalSuccess(newPlayer.func_145782_y()));
            }
        });
    }

    public static void abortRescue(PlayerEntity player) {
        LazyOptional revival = player.getCapability(CapabilityHardcoreRevival.REVIVAL_CAPABILITY, null);
        revival.ifPresent(it -> {
            if (it.getRescueTarget() != null) {
                it.setRescueTime(0);
                it.setRescueTarget(null);
                NetworkHandler.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageRevivalProgress(-1, -1.0f));
            }
        });
    }
}

