/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.network;

import java.util.function.Supplier;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.network.NetworkHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageDeathTime {
    private final int deathTime;

    public MessageDeathTime(int deathTime) {
        this.deathTime = deathTime;
    }

    public static void encode(MessageDeathTime message, PacketBuffer buf) {
        buf.writeInt(message.deathTime);
    }

    public static MessageDeathTime decode(PacketBuffer buf) {
        int deathTime = buf.readInt();
        return new MessageDeathTime(deathTime);
    }

    public static void handle(MessageDeathTime message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        NetworkHandler.ensureClientSide(context);
        context.enqueueWork(() -> HardcoreRevival.client.ifPresent(it -> it.setDeathTime(message.deathTime)));
        context.setPacketHandled(true);
    }
}

