/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hbm.config;

import com.mactso.hbm.config.toolManager;
import com.mactso.hbm.config.whiteListManager;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="hbm")
@Mod.EventBusSubscriber
public class MyConfig {
    @Config.Ignore
    public static double serverDigSpeed = 1.0;
    @Config.Ignore
    public static double serverDownSpeed = 1.01;
    @Config.Ignore
    public static boolean serverSide = false;
    @Config.Comment(value={"Exhaustion Type"})
    @Config.Name(value="Exhaustion Type : 0 = Fixed, 1 = Proportional to Depth")
    @Config.RangeInt(min=0, max=1)
    public static int aExhaustionType = 1;
    @Config.Comment(value={"Depth Dig Speed Modifier"})
    @Config.Name(value="Dig   1 to 11.0 : 'No Effect' to 'Slow'")
    @Config.RangeDouble(min=1.0, max=11.0)
    public static double aDigSpeedModifier = 1.09;
    @Config.Comment(value={"Down Speed Modifier"})
    @Config.Name(value="Down 1 to 11.0 : 'No Effect' to 'Slow'")
    @Config.RangeDouble(min=1.0, max=11.0)
    public static double aDownSpeedModifier = 1.03;
    @Config.Comment(value={"Ignore Ore?"})
    @Config.Name(value="True: Ignore, False: Exhausting & Slow Ore")
    public static boolean aIgnoreOreFlag = true;
    @Config.Comment(value={"Print Debugging Messages to Log"})
    @Config.Name(value="Log Debugging: 0=minimal, 1= log, 2 = log + chat")
    @Config.RangeInt(min=0, max=2)
    public static int aDebugLevel = 0;
    @Config.Comment(value={"\"Tool Values: mod:tool, Dimension #, ExhaustionMaxY(5-255), Exhaustion Amount(0-40)"})
    @Config.Name(value="Tool Values: mod:tool, Dim, Height, Exhaustion")
    public static String[] defaultTools = new String[]{"hbm:default,0,48,10", "Minecraft:torch,0,48,0.01", "minecraft:wooden_pickaxe,0,48,8.0", "minecraft:stone_pickaxe,0,48,4.0", "minecraft:iron_pickaxe,0,48,2.0", "minecraft:gold_pickaxe,0,48,1.5", "minecraft:diamond_pickaxe,0,48,1.0", "minecraft:wooden_shovel,0,48,8.0", "minecraft:stone_shovel,0,48,4.0", "minecraft:iron_shovel,0,48,2.0", "minecraft:gold_shovel,0,48,1.5", "minecraft:diamond_shovel,0,48,1.0", "minecraft:wooden_axe,0,48,2.0", "minecraft:stone_axe,0,48,1.0", "minecraft:iron_axe,0,48,0.5", "minecraft:gold_axe,0,48,0.3", "minecraft:diamond_axe,0,48,0.25", "minecraft:iron_pickaxe,-1,124,2.2", "minecraft:diamond_pickaxe,-1,124,1.2"};
    @Config.Comment(value={"\"Whitelist Blocks: Mod:Block"})
    @Config.Name(value="Whitelist Blocks : Mod: Block")
    public static String[] whiteList = new String[]{"ore_stone_variants:coal_ore", "ore_stone_variants:iron_ore", "ore_stone_variants:gold_ore", "ore_stone_variants:diamond_ore", "ore_stone_variants:lapis_ore", "ore_stone_variants:redstone_ore", "rockcandy:candy_ore", "minecraft:planks", "minecraft:fence"};

    @SubscribeEvent
    public static void onModConfigEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("hbm")) {
            ConfigManager.sync((String)event.getModID(), (Config.Type)Config.Type.INSTANCE);
            toolManager.toolInit();
            whiteListManager.whitelistInit();
            if (!serverSide) {
                if (aDebugLevel > 0) {
                    System.out.println("HarderBranchMining (" + serverSide + ") Configuration Change " + aDigSpeedModifier + "reset to=" + serverDigSpeed);
                    System.out.println("HarderBranchMining (" + serverSide + ") Configuration Change " + aDownSpeedModifier + "reset to=" + serverDownSpeed);
                }
                aDigSpeedModifier = serverDigSpeed;
                aDownSpeedModifier = serverDownSpeed;
            }
        }
    }
}

