/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hbm.config;

import com.mactso.hbm.config.MyConfig;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class toolManager {
    public static Hashtable<String, toolItem> toolHashtable = new Hashtable();
    private static String defaultToolString = "hbm:default";
    private static int defaultToolDimension = 0;
    private static String defaultToolKey = defaultToolString + ":" + defaultToolDimension;

    public static toolItem getToolInfo(String key, int dim) {
        String iKey = key + ":" + dim;
        toolItem t = toolHashtable.get(iKey);
        if (t == null && (t = toolHashtable.get(iKey = key + ":0")) == null) {
            t = toolHashtable.get(defaultToolKey);
        }
        return t;
    }

    public static void toolInit() {
        toolHashtable.clear();
        for (int i = 0; i < MyConfig.defaultTools.length; ++i) {
            try {
                double tExhaustionAmt;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultTools[i], ",");
                String key = st.nextToken() + ":" + st.nextToken();
                double tExhaustionY = Double.parseDouble(st.nextToken());
                if (tExhaustionY < 5.0 || tExhaustionY > 255.0) {
                    tExhaustionY = 48.0;
                }
                if ((tExhaustionAmt = Double.parseDouble(st.nextToken())) < 0.0 || tExhaustionAmt > 40.0) {
                    tExhaustionAmt = 0.01;
                }
                toolHashtable.put(key, new toolItem(tExhaustionY, tExhaustionAmt));
                continue;
            }
            catch (Exception e) {
                System.out.println("HarderBranchMining: Bad Tool Config : " + MyConfig.defaultTools[i]);
            }
        }
        if (toolManager.getToolInfo(defaultToolString, defaultToolDimension) == null) {
            double tExhaustionY = 48.0;
            double tExhaustionAmt = 10.0;
            toolHashtable.put(defaultToolKey, new toolItem(tExhaustionY, tExhaustionAmt));
        }
    }

    public static class toolItem {
        double toolExhaustionY;
        double toolExhaustionAmount;

        public toolItem(double toolExhaustionY, double toolExhaustionAmount) {
            this.toolExhaustionY = toolExhaustionY;
            this.toolExhaustionAmount = toolExhaustionAmount;
        }

        public double getExhaustionY() {
            return this.toolExhaustionY;
        }

        public double getExhaustionAmt() {
            return this.toolExhaustionAmount;
        }
    }
}

