/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hbm.event;

import com.mactso.hbm.config.MyConfig;
import com.mactso.hbm.config.toolManager;
import com.mactso.hbm.config.whiteListManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="hbm")
public class BlockBreakHandler {
    private static final int EXHAUSTION_FIXED = 0;
    private static final int EXHAUSTION_DEPTH = 1;
    private static int debugLimiter = 0;

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        double depthBasedExhaustionFactor = 0.01;
        double tempExhaustionAmount = 0.0;
        EntityPlayer player = event.getPlayer();
        Item tempItem = player.func_184614_ca().func_77973_b();
        if (1.0f >= event.getState().func_185887_b(event.getWorld(), event.getPos())) {
            if (MyConfig.aDebugLevel > 1) {
                TextComponentString component = new TextComponentString("Block Broken! Soft Block.  No Exhaustion.");
                component.func_150256_b().func_150238_a(TextFormatting.GREEN);
                player.func_145747_a((ITextComponent)component);
            }
            return;
        }
        Block block = event.getState().func_177230_c();
        if (whiteListManager.whitelistHashSet.contains(block)) {
            if (MyConfig.aDebugLevel > 1) {
                TextComponentString component = new TextComponentString("White list Block Broken: " + block.toString() + ".  No exhaustion");
                component.func_150256_b().func_150238_a(TextFormatting.GREEN);
                player.func_145747_a((ITextComponent)component);
            }
            return;
        }
        toolManager.toolItem toolInfo = toolManager.getToolInfo(tempItem.getRegistryName().toString(), player.field_71093_bK);
        depthBasedExhaustionFactor = toolInfo.getExhaustionY() - (double)event.getPos().func_177956_o();
        if (depthBasedExhaustionFactor < 0.0) {
            return;
        }
        depthBasedExhaustionFactor = MyConfig.aExhaustionType == 1 ? (depthBasedExhaustionFactor /= toolInfo.getExhaustionY()) : 1.0;
        tempExhaustionAmount = toolInfo.getExhaustionAmt() * depthBasedExhaustionFactor;
        event.getPlayer().func_71024_bL().func_75113_a((float)tempExhaustionAmount);
        if (MyConfig.aDebugLevel > 0) {
            System.out.println("Block Broken! Player:" + player.func_70005_c_() + ", Dimension" + player.field_71093_bK + ", Pos:" + event.getPos() + ", tempExhaustionAmount:" + tempExhaustionAmount);
            if (MyConfig.aDebugLevel > 1) {
                TextComponentString component = new TextComponentString("Block Broken! Player:" + player.func_70005_c_() + ", Dimension" + player.field_71093_bK + ", Pos:" + event.getPos() + ", tempExhaustionAmount:" + tempExhaustionAmount);
                player.func_145747_a((ITextComponent)component);
            }
        }
    }

    @SubscribeEvent
    public void blockBreakSpeed(PlayerEvent.BreakSpeed event) {
        float baseDestroySpeed;
        Block block;
        double depthBasedSpeedFactor = 0.0;
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (event.getEntityPlayer().func_184812_l_()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        Item playerItem = player.func_184614_ca().func_77973_b();
        boolean toolHarvestsBlockFaster = false;
        float os = event.getOriginalSpeed();
        if (event.getOriginalSpeed() > 1.0f) {
            toolHarvestsBlockFaster = true;
        }
        if (whiteListManager.whitelistHashSet.contains(block = event.getState().func_177230_c())) {
            if (MyConfig.aDebugLevel > 1) {
                TextComponentString component = new TextComponentString("White list Block Breaking: " + block.toString() + " No speed change.");
                component.func_150256_b().func_150238_a(TextFormatting.GREEN);
                player.func_145747_a((ITextComponent)component);
            }
            return;
        }
        if (block instanceof BlockOre && MyConfig.aIgnoreOreFlag) {
            return;
        }
        toolManager.toolItem toolInfo = toolManager.getToolInfo(playerItem.getRegistryName().toString(), player.field_71093_bK);
        int altitude = event.getPos().func_177956_o();
        if (altitude < 5) {
            altitude = 5;
        }
        if ((double)altitude > toolInfo.getExhaustionY()) {
            return;
        }
        depthBasedSpeedFactor = 1.0 - (double)altitude / toolInfo.getExhaustionY();
        IBlockState s = event.getState();
        float newDestroySpeed = baseDestroySpeed = event.getOriginalSpeed();
        if (MyConfig.aDigSpeedModifier > 1.0) {
            newDestroySpeed = baseDestroySpeed - baseDestroySpeed * (float)depthBasedSpeedFactor;
            newDestroySpeed /= (float)MyConfig.aDigSpeedModifier;
            if (event.getPos().func_177956_o() < player.func_180425_c().func_177956_o()) {
                newDestroySpeed /= (float)MyConfig.aDownSpeedModifier;
            }
        }
        if (newDestroySpeed > 0.0f) {
            event.setNewSpeed(newDestroySpeed);
        }
        if (MyConfig.aDebugLevel > 1 && debugLimiter++ > 5) {
            System.out.println("Block Speed ! depthSpeedFactor:" + depthBasedSpeedFactor * 100.0 + "%");
            System.out.println("Block Speed ! Configured digSpeedModifer:" + MyConfig.aDigSpeedModifier * 100.0 + "%");
            System.out.println("Block Speed ! Original Speed: " + baseDestroySpeed + " newSpeedSet:" + event.getNewSpeed() + "DigSpeedMod:" + MyConfig.aDigSpeedModifier + ".");
            if (MyConfig.aDebugLevel > 1) {
                TextComponentString component = new TextComponentString("Block Speed ! Original Speed: " + baseDestroySpeed + " newSpeedSet:" + event.getNewSpeed() + ".");
                player.func_145747_a((ITextComponent)component);
            }
            debugLimiter = 0;
        }
    }
}

