/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hbm.network;

import com.mactso.hbm.config.MyConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class HBMPacket
implements IMessage {
    private double aDigSpeedModifier;
    private double aDownSpeedModifier;

    public HBMPacket() {
    }

    public HBMPacket(double aNewDigSpeedModifier, double aNewDownSpeedModifier) {
        this.aDigSpeedModifier = aNewDigSpeedModifier;
        this.aDownSpeedModifier = aNewDownSpeedModifier;
    }

    public void fromBytes(ByteBuf buf) {
        this.aDigSpeedModifier = buf.readDouble();
        this.aDownSpeedModifier = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.aDigSpeedModifier);
        buf.writeDouble(this.aDownSpeedModifier);
    }

    public static class HBMHandler
    implements IMessageHandler<HBMPacket, IMessage> {
        public IMessage onMessage(HBMPacket message, MessageContext ctx) {
            if (MyConfig.aDebugLevel > 0) {
                System.out.println("Message dig: " + message.aDigSpeedModifier);
                System.out.println("Message down: " + message.aDownSpeedModifier);
            }
            Minecraft.func_71410_x().func_152344_a(() -> {
                MyConfig.serverDigSpeed = message.aDigSpeedModifier;
                MyConfig.aDigSpeedModifier = message.aDigSpeedModifier;
                MyConfig.serverDownSpeed = message.aDigSpeedModifier;
                MyConfig.aDownSpeedModifier = message.aDownSpeedModifier;
            });
            return null;
        }
    }
}

