/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hbm.config;

import com.mactso.hbm.config.ToolManager;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="hbm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static int aExhaustionType;
    public static int aDebugLevel;
    public static double aDownSpeedModifier;
    public static double aDigSpeedModifier;
    public static boolean aNormalOre;
    public static String[] defaultTools;
    public static String defaultTools6464;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == SERVER_SPEC) {
            MyConfig.bakeConfig();
            ToolManager.toolInit();
        }
    }

    public static void pushValues() {
        System.out.println("dbgL:" + aDebugLevel + " exhT:" + aExhaustionType + " DigSM:" + aDigSpeedModifier + " DwnSM:" + aDigSpeedModifier);
        MyConfig.SERVER.debugLevel.set((Object)aDebugLevel);
        MyConfig.SERVER.exhaustionType.set((Object)aExhaustionType);
        MyConfig.SERVER.aDigSpeedModifier.set((Object)aDigSpeedModifier);
        MyConfig.SERVER.aDownExhaustion.set((Object)aDownSpeedModifier);
        MyConfig.SERVER.aNormalOre.set((Object)aNormalOre);
    }

    public static void bakeConfig() {
        aExhaustionType = (Integer)MyConfig.SERVER.exhaustionType.get();
        aDebugLevel = (Integer)MyConfig.SERVER.debugLevel.get();
        aDigSpeedModifier = (Double)MyConfig.SERVER.aDigSpeedModifier.get();
        aDownSpeedModifier = (Double)MyConfig.SERVER.aDownExhaustion.get();
        aNormalOre = (Boolean)MyConfig.SERVER.aNormalOre.get();
        defaultTools6464 = (String)MyConfig.SERVER.defaultToolsActual.get();
        defaultTools = ((List)MyConfig.SERVER.defaultTools.get()).toArray(new String[((List)MyConfig.SERVER.defaultTools.get()).size()]);
        System.out.println("HarderBranchMiningConfig Type:" + aExhaustionType + ", Debug Level:" + aDebugLevel);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue exhaustionType;
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.DoubleValue aDigSpeedModifier;
        public final ForgeConfigSpec.DoubleValue aDownExhaustion;
        public final ForgeConfigSpec.BooleanValue aNormalOre;
        public final ForgeConfigSpec.ConfigValue<String> defaultToolsActual;
        public final String defaultTools6464 = "hbm:default,0,48,10.0;\n\rminecraft:torch,0,48,0.2;\n\rminecraft:wooden_pickaxe,0,48,8.0;\n\rminecraft:stone_pickaxe,0,48,4.0;\n\rminecraft:iron_pickaxe,0,48,2.0;\n\rminecraft:golden_pickaxe,0,48,1.5;\n\rminecraft:diamond_pickaxe,0,48,1.0;\n\rminecraft:wooden_shovel,0,48,8.0;\n\rminecraft:stone_shovel,0,48,4.0;\n\rminecraft:iron_shovel,0,48,2.0;\n\rminecraft:golden_shovel,0,48,1.5;\n\rminecraft:diamond_shovel,0,48,1.0;\n\rminecraft:wooden_axe,0,48,2.0;\n\rminecraft:stone_axe,0,48,1.0;\n\rminecraft:iron_axe,0,48,0.5;\n\rminecraft:golden_axe,0,48,0.3;\n\rminecraft:diamond_axe,0,48,0.25;\n\rminecraft:iron_pickaxe,-1,124,2.2;\n\rminecraft:diamond_pickaxe,-1,124,1.2;\n\r";
        public final ForgeConfigSpec.ConfigValue<List<String>> defaultTools;
        public static List<String> defaultToolsArray = Arrays.asList("hbm:default,0,48,10.0", "minecraft:torch,0,48,0.2", "minecraft:wooden_pickaxe,0,48,8.0", "minecraft:stone_pickaxe,0,48,4.0", "minecraft:iron_pickaxe,0,48,2.0", "minecraft:golden_pickaxe,0,48,1.5", "minecraft:diamond_pickaxe,0,48,1.0", "minecraft:wooden_shovel,0,48,8.0", "minecraft:stone_shovel,0,48,4.0", "minecraft:iron_shovel,0,48,2.0", "minecraft:golden_shovel,0,48,1.5", "minecraft:diamond_shovel,0,48,1.0", "minecraft:wooden_axe,0,48,2.0", "minecraft:stone_axe,0,48,1.0", "minecraft:iron_axe,0,48,0.5", "minecraft:golden_axe,0,48,0.3", "minecraft:diamond_axe,0,48,0.25", "minecraft:iron_pickaxe,-1,124,2.2", "minecraft:diamond_pickaxe,-1,124,1.2");

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Exhaustion Control Values");
            this.exhaustionType = builder.comment("Exhaustion Type: 0 = Fixed, 1=Proportional").translation("hbm.config.exhaustionType").defineInRange("exhaustionType", () -> 1, 0, 1);
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("hbm.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.aDigSpeedModifier = builder.comment("Digging Speed Modifer: (none) 1.0 to (max) 32.0").translation("hbm.config.aDigSpeedModifier").defineInRange("aDigSpeedModifier", () -> 1.09, 1.0, 32.0);
            this.aDownExhaustion = builder.comment("Down Speed Modifer: (none) 1.0 to (max) 32.0").translation("hbm.config.aDownExhaustion").defineInRange("aDownExhaustion", () -> 1.03, 1.0, 32.0);
            this.aNormalOre = builder.comment("Normal Ore Behavior: true").translation("hbm.config.aNormalOre").define("aNormalOre", () -> true);
            builder.pop();
            builder.push("Tool Values 6464");
            this.defaultToolsActual = builder.comment("Tool String 6464").translation("hbm.configdefaultToolsActual").define("defaultToolsActual", (Object)"hbm:default,0,48,10.0;\n\rminecraft:torch,0,48,0.2;\n\rminecraft:wooden_pickaxe,0,48,8.0;\n\rminecraft:stone_pickaxe,0,48,4.0;\n\rminecraft:iron_pickaxe,0,48,2.0;\n\rminecraft:golden_pickaxe,0,48,1.5;\n\rminecraft:diamond_pickaxe,0,48,1.0;\n\rminecraft:wooden_shovel,0,48,8.0;\n\rminecraft:stone_shovel,0,48,4.0;\n\rminecraft:iron_shovel,0,48,2.0;\n\rminecraft:golden_shovel,0,48,1.5;\n\rminecraft:diamond_shovel,0,48,1.0;\n\rminecraft:wooden_axe,0,48,2.0;\n\rminecraft:stone_axe,0,48,1.0;\n\rminecraft:iron_axe,0,48,0.5;\n\rminecraft:golden_axe,0,48,0.3;\n\rminecraft:diamond_axe,0,48,0.25;\n\rminecraft:iron_pickaxe,-1,124,2.2;\n\rminecraft:diamond_pickaxe,-1,124,1.2;\n\r");
            builder.pop();
            builder.push("Tool Values");
            this.defaultTools = builder.comment("Tool String").translation("hbm.configdefaultTools").define("defaultTools", defaultToolsArray);
            builder.pop();
        }
    }
}

